uniform sampler2D MainTex;
uniform sampler2D NoiseTex;
uniform float ripple;
uniform vec2 noisePos;
uniform float distort;
uniform float distortPos;

void main()
	{
	vec2 pos = gl_TexCoord[0].st;
	vec4 col;
	if ( distort == 0.0 )
		{
		col = texture2D( MainTex, pos );
		}
	else
		{
		float a = pos.y * distortPos + distortPos;
		float xr = sin( a ) * distort;
		float xg = xr * 1.5;
		float xb = xg * 1.5;
		
		if ( pos.x + xr < 0.0 || pos.x + xr > 1.0 )
			{
			col = vec4( 0.0, 0.0, 0.0, 1.0 );
			}
		else
			{
			col = vec4( texture2D( MainTex, vec2( pos.x + xr, pos.y ) ).r,
						texture2D( MainTex, vec2( pos.x + xg, pos.y ) ).g,
						texture2D( MainTex, vec2( pos.x + xb, pos.y ) ).b,
						1.0 );
			}
		}
	float x = pos.x + pos.y + col.r + col.g + col.b + col.a;
	col *= 1.0 + sin( x * ripple );
	col *= 0.75 + texture2D( NoiseTex, gl_TexCoord[0].st + noisePos ).r * 0.5;
	gl_FragColor = col * col;
	}