uniform sampler2D MainTex;
uniform sampler2D NoiseTex;
uniform vec2 noisePos;
uniform float whiteNoiseAmount;
uniform float blur;

void main()
	{
	float detail = 0.05;
	float steps = 2.0 / detail + 1.0;

	vec2 pos = gl_TexCoord[0].st;
	vec2 delta = blur * ( vec2( 0.5, 0.5 ) - pos );
	vec4 col;
	for( float i = -1.0; i <= 1.0; i += detail )
		{
		vec2 p = clamp( pos + i * delta, vec2( 0.0 ), vec2( 1.0 ) );
		col += texture2D( MainTex, p );
		}
	col /= steps;
	
	col *= 2.0 * ( 0.25 + 0.5 * texture2D( NoiseTex, gl_TexCoord[0].st + noisePos ).r );
	col += whiteNoiseAmount * texture2D( NoiseTex, gl_TexCoord[0].st + noisePos );
	col = min( col * col, vec4( 1.0 ) );
	gl_FragColor = col;
	}