struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Alpha : ALPHA;
float V_InvScreenW : INVSCREENW;
float V_InvScreenH : INVSCREENH;
float V_Rand1 : RAND1; // 0-1
float V_Rand2 : RAND2;
float V_Rand3 : RAND3;
float V_Var1 : VAR1;  // IntensX
float V_Var2 : VAR2;  // IntensY
float V_Var3 : VAR3;  // Random

float4 DispRGB(float2 xy, float Disp, float Rand)
{
  xy.x = xy.x + (Disp * V_InvScreenW * V_Var1) + (15.f * V_InvScreenW * V_Var3 * Rand);
  xy.y = xy.y + (Disp * V_InvScreenH * V_Var2) + (15.f * V_InvScreenH * V_Var3 * Rand);
  return tex2D(Sampler, xy);
}

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 r = DispRGB(In.Tex0.xy, 13.f, V_Rand1 - 0.5);
  float4 g = DispRGB(In.Tex0.xy,  7.f, V_Rand2 - 0.5);
  float4 b = DispRGB(In.Tex0.xy,-10.f, V_Rand3 - 0.5);
  float  a = V_Alpha * (r.a + g.a + b.a) / 3.0;
  return float4(r.r,g.g,b.b,a);
}

technique RGB
{
  pass PassRGB
  {
    PixelShader = compile ps_2_0 PS();
  }
}
