
#ifndef NUM_LIGHTS
	#define NUM_LIGHTS 1
#endif

#define FOG

//varying vec3 normal;
varying vec3 lightDir[NUM_LIGHTS];
varying vec3 eye;
varying float camdot;
varying vec3 pos;
varying vec3 tn, tt, tb;
varying vec4 glVertex;
varying vec3 v_m;

mat3 glNormalMatrixInverse(void)
{
	return mat3(gl_ModelViewMatrix[0][0], gl_ModelViewMatrix[1][0], gl_ModelViewMatrix[2][0],
				gl_ModelViewMatrix[0][1], gl_ModelViewMatrix[1][1], gl_ModelViewMatrix[2][1],
				gl_ModelViewMatrix[0][2], gl_ModelViewMatrix[1][2], gl_ModelViewMatrix[2][2]);
}

mat3 tbnInverse(vec3 t, vec3 n, vec3 b) {
	return mat3(t.x, n.x, b.x,
	            t.y, n.y, b.y,
	            t.z, n.z, b.z);
}

void main() {
//	gl_TexCoord[0] = gl_TextureMatrix[0]*gl_MultiTexCoord0;
	gl_TexCoord[0] = gl_MultiTexCoord0;

	vec3 tangent = vec3(gl_MultiTexCoord7);

	vec3 n = normalize(gl_NormalMatrix*gl_Normal);
	vec3 t = normalize(gl_NormalMatrix*tangent);
	vec3 b = cross(n, t);

	pos = vec3(gl_ModelViewMatrix*gl_Vertex);

	vec3 tmpVec;
	for (int i = 0; i < NUM_LIGHTS; i++) {
		tmpVec = gl_LightSource[i].position.xyz-pos;

		lightDir[i].x = dot(tmpVec, t);
		lightDir[i].y = dot(tmpVec, n);
		lightDir[i].z = dot(tmpVec, b);
//		lightDir[i] = tmpVec;
	}

	tmpVec = -pos.xyz;
	eye.x = dot(tmpVec, t);
	eye.y = dot(tmpVec, n);
	eye.z = dot(tmpVec, b);

	camdot = 1.0-dot(n, normalize(-pos.xyz));
	camdot = camdot*camdot*camdot*2.0;

	tt = t;
	tn = n;
	tb = b;

	glVertex = gl_Vertex;
//	v_m = normalize(-glNormalMatrixInverse()*gl_ModelViewMatrix[3].xyz - glVertex.xyz);
	v_m = normalize(-tbnInverse(t,n,b)*gl_ModelViewMatrix[3].xyz - glVertex.xyz);

	//normal = n.xyz;

	#ifdef FOG
		gl_FogFragCoord = length(pos.xyz);
	#endif

	gl_Position = ftransform();
}
