
#ifndef _CG_VECTOR2_H
#define _CG_VECTOR2_H

#include "cgMatrix.h"
#include "cgVector4.h"

namespace gravity
{

	class cgVector2
	{
	public:
		float x, y;

		cgVector2();
		cgVector2( const float * );
		cgVector2( float x, float y );

		operator float* ();
		operator const float* () const;

		cgVector2& operator += ( const cgVector2& );
		cgVector2& operator -= ( const cgVector2& );
		cgVector2& operator *= ( float );
		cgVector2& operator /= ( float );

		cgVector2 operator + () const;
		cgVector2 operator - () const;

		cgVector2 operator + ( const cgVector2& ) const;
		cgVector2 operator - ( const cgVector2& ) const;
		cgVector2 operator * ( float ) const;
		cgVector2 operator / ( float ) const;

		friend cgVector2 operator * ( float, const cgVector2& );

		bool operator == ( const cgVector2& ) const;
		bool operator != ( const cgVector2& ) const;

		void	add					( const cgVector2 *v );
		void	baryCentric			( const cgVector2 *v1, const cgVector2 *v2, float f, float g );
		void	catmullRom			( const cgVector2 *v1, const cgVector2 *v2, const cgVector2 *v3, float s );
		float	ccw					( const cgVector2 *v );
		float	dot					( const cgVector2 *v );
		void	hermite				( const cgVector2 *v1, const cgVector2 *v2, const cgVector2 *v3, float s );
		float	lenght				(  );
		float	lenghtSqr			(  );
		void	lerp				( const cgVector2 *v, float s );
		void	maximize			( const cgVector2 *v );
		void	minimize			( const cgVector2 *v );
		void	normalize			(  );
		void	scale				( float s );
		void	subtract			( const cgVector2 *v );
		cgVector4*	transform		( const cgMatrix *m );
		void	transformCoord		( const cgMatrix *m );
		void	transformNormal		( const cgMatrix *m );
	};

}

#endif // _CG_VECTOR2_H