
#ifndef _CG_QUATERNION_H
#define _CG_QUATERNION_H

#include "cgPlane.h"
#include "cgQuaternion.h"
#include "cgVector2.h"
#include "cgVector3.h"
#include "cgVector4.h"
#include "cgViewport.h"

namespace gravity
{

	class cgQuaternion
	{
	public:
		float x, y, z, w;

		cgQuaternion();
		cgQuaternion( const float * );
		cgQuaternion( float x, float y, float z, float w );

		operator float* ();
		operator const float* () const;

		void operator = ( const cgQuaternion& );
		void operator = ( float );

		cgQuaternion& operator += ( const cgQuaternion& );
		cgQuaternion& operator -= ( const cgQuaternion& );
		cgQuaternion& operator *= ( const cgQuaternion& );
		cgQuaternion& operator *= ( float );
		cgQuaternion& operator /= ( float );

		cgQuaternion operator + () const;
		cgQuaternion operator - () const;

		cgQuaternion operator + ( const cgQuaternion& ) const;
		cgQuaternion operator - ( const cgQuaternion& ) const;
		cgQuaternion operator * ( const cgQuaternion& ) const;
		cgQuaternion operator * ( float ) const;
		cgQuaternion operator / ( float ) const;

		friend cgQuaternion operator * ( float, const cgQuaternion& );

		bool operator == ( const cgQuaternion& ) const;
		bool operator != ( const cgQuaternion& ) const;

		void	baryCentric				( const cgQuaternion *q1, const cgQuaternion *q2, float f, float g );
		void	conjugate				(  );
		float	dot						( const cgQuaternion *q );
		void	exp						(  );
		void	identity				(  );
		void	inverse					(  );
		bool	isIdentity				(  );
		float	length					(  );
		float	lengthSq				(  );
		void	ln						(  );
		void	multiply				( const cgQuaternion *q );
		void	normalize				(  );
		void	rotationAxis			( const cgVector3 *v, float angle );
		void	rotationMatrix			( const cgMatrix *m);
		void	rotationYawPitchRoll	( float yaw, float pitch, float roll );
		void	slerp					( const cgQuaternion *q, float t );
		void	squad					( const cgQuaternion *qa, const cgQuaternion *qb, const cgQuaternion *qc, float t );
		void	toAxisAngle				( cgVector3 *axis, float *angle );
	};

}

#endif // _CG_QUATERNION_H