
#include "cgMath.h"

namespace gravity
{

	cgPlane::cgPlane( const float * f )
	{
		a = f[0];
		b = f[1];
		c = f[2];
		d = f[3];
	}

	cgPlane::cgPlane( float a, float b, float c, float d )
	{
		this->a = a;
		this->b = b;
		this->c = c;
		this->d = d;
	}


	// casting
	cgPlane::operator float* ()
	{
		return (float *) this;
	}

	cgPlane::operator const float* () const
	{
		return (const float *) this;
	}


	// assignment operators
	cgPlane& cgPlane::operator *= ( float s )
	{
		a *= s;
		b *= s;
		c *= s;
		d *= s;
		return *this;
	}

	cgPlane& cgPlane::operator /= ( float s )
	{
		float i = 1.0f / s;
		a *= i;
		b *= i;
		c *= i;
		d *= i;
		return *this;
	}


	// unary operators
	cgPlane cgPlane::operator + () const
	{
		return *this;
	}

	cgPlane cgPlane::operator - () const
	{
		return cgPlane(-a, -b, -c, -d);
	}


	// binary operators
	cgPlane cgPlane::operator * ( float s ) const
	{
		return cgPlane(a * s, b * s, c * s, d * s);
	}

	cgPlane cgPlane::operator / ( float s ) const
	{
		float i = 1.0f / s;
		return cgPlane(a * i, b * i, c * i, d * i);
	}

	cgPlane operator * (float s, const cgPlane& p )
	{
		return cgPlane(p.a * s, p.b * s, p.c * s, p.d * s);
	}

	bool cgPlane::operator == ( const cgPlane& p ) const
	{
		return a == p.a && b == p.b && c == p.c && d == p.d;
	}

	bool cgPlane::operator != ( const cgPlane& p ) const
	{
		return a != p.a || b != p.b || c != p.c || d != p.d;
	}

}