
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

#include "fMenu.h"

namespace fingers
{

	fMenu::fMenu()
	{

	}

	void fMenu::renderBack(int x, int y, int w, int h)
	{
		glPushMatrix();
		glLoadIdentity();
		gluOrtho2D(0.0f, 800.0f, 600.0f, 0.0f);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.0f, 0.0f, 0.0f, 0.5f);

		glBegin(GL_QUADS);
			glVertex2f(x, y);
			glVertex2f(x + w, y);
			glVertex2f(x + w, y + h);
			glVertex2f(x, y + h);
		glEnd();

		glDisable(GL_BLEND);
		glPopMatrix();
	}

	void fMenu::renderPoint(int x, int y)
	{
		glPushMatrix();
		glLoadIdentity();
		gluOrtho2D(0.0f, 800.0f, 600.0f, 0.0f);
		glColor3f(1.0f, 1.0f, 1.0f);

		glBegin(GL_QUADS);
			glVertex2f(x - 4.0f, y - 4.0f);
			glVertex2f(x + 4.0f, y - 4.0f);
			glVertex2f(x + 4.0f, y + 4.0f);
			glVertex2f(x - 4.0f, y + 4.0f);
		glEnd();

		glPopMatrix();
	}

	void fMenu::printTitle(int x, int y, const char* text)
	{
		glColor3f(0.0f, 0.0f, 0.0f);
		fontTitle.print(x+2, y+2, text);

		glColor3f(0.0f, 0.0f, 1.0f);
		fontTitle.print(x, y, text);
	}

	void fMenu::printItem(int x, int y, const char* text)
	{
		glColor3f(0.0f, 0.0f, 0.0f);
		fontItem.print(x+1, y+1, text);

		glColor3f(1.0f, 1.0f, 1.0f);
		fontItem.print(x, y, text);
	}

	void fMenu::initialize(HDC hDC)
	{
		this->hDC = hDC;

		fontTitle.create(hDC, 48, "Trebuchet MS");
		fontItem.create(hDC, 22, "Trebuchet MS");
	}

	int fMenu::input(int key)
	{
		if ( key == VK_UP )
		{
			currentItem--;
		}
		else if ( key == VK_DOWN )
		{
			currentItem++;
		}

		if ( currentMenu == MENU_MAIN )
		{
			if ( currentItem > 4 )
				currentItem = 0;
			else if ( currentItem < 0 )
				currentItem = 4;
		}
		else if ( currentMenu == MENU_NEW )
		{
			if ( currentItem > 3 )
				currentItem = 0;
			else if ( currentItem < 0 )
				currentItem = 3;
		}
		else if ( currentMenu == MENU_HOWTOPLAY )
		{
			if ( currentItem > 2 )
				currentItem = 0;
			else if ( currentItem < 0 )
				currentItem = 2;
		}
		else if ( currentMenu == MENU_EXIT )
		{
			if ( key == 'Y' )
				exit(0);
			else if ( key == 'N' )
				currentMenu = MENU_MAIN;

			return 0;
		}

		if ( key == VK_RETURN )
		{
			switch ( currentMenu )
			{
			case MENU_MAIN:
				switch ( currentItem )
				{
				case 0: currentMenu = MENU_NEW;			break;
				case 1: currentMenu = MENU_HOWTOPLAY;	break;
				case 3: currentMenu = MENU_CREDITS;		break;
				case 4: currentMenu = MENU_EXIT;		break;
				}
				break;

			case MENU_NEW:
				switch ( currentItem )
				{
				case 0:	return 0x0100;
				case 1:	return 0x0101;
				case 2:	return 0x0102;
				case 3:	return 0x0103;
				}
				break;
			}

			currentItem = 0;
		}

		if ( key == VK_ESCAPE )
		{
			switch ( currentMenu )
			{
			case MENU_MAIN:	currentMenu = MENU_EXIT; break;
			case MENU_NEW:
			case MENU_HOWTOPLAY:
			case MENU_CREDITS:
				currentMenu = MENU_MAIN; break;
			}

			currentItem = 0;
		}

		return 0;
	}

	void fMenu::render()
	{
		renderBack(180, 170, 400, 600);

		if ( currentMenu == MENU_MAIN )
		{
			printTitle(200, 200, "Fingers Menu");
			printItem(250, 250, "New Game");
			printItem(250, 280, "How to Play");
			printItem(250, 310, "Highscore");
			printItem(250, 340, "Credits");
			printItem(250, 370, "Exit");

			renderPoint(225, 264 + 30 * currentItem);
		}
		else if ( currentMenu == MENU_NEW )
		{
			printTitle(200, 200, "New Game");
			printItem(250, 250, "Easy");
			printItem(250, 280, "Normal");
			printItem(250, 310, "Hard");
			printItem(250, 340, "Insane");

			renderPoint(225, 264 + 30 * currentItem);
		}
		else if ( currentMenu == MENU_HOWTOPLAY )
		{
			if ( currentItem == 0 )
			{
				printTitle(200, 200, "How to Play");
				printItem(220, 230, "Type the words that appear, before they");
				printItem(220, 250, "reach the edge of the screen. If it does,");
				printItem(220, 270, "you'll loose.");
				printItem(220, 300, "The yellow word is the current word. To");
				printItem(220, 320, "advance to the next word, press [SPACE].");
				printItem(220, 350, "Green indicates a correct letter, red");
				printItem(220, 370, "indicates an erronous one. Backspace is");
				printItem(220, 390, "allowed, but will result in a small penalty");
				printItem(220, 410, "An error will not lead to game-over.");
				printItem(220, 440, "While easy is easy, you cannot achieve very");
				printItem(220, 460, "high scores. Normal gets 2x the score, hard");
				printItem(220, 480, "gets 3x and insane 4x. Also, the length of");
				printItem(220, 500, "the word adds alot of value.");

				glColor3f(1.0f, 1.0f, 0.0f);
				fontItem.print(253, 300, "yellow");

				glColor3f(0.0f, 1.0f, 0.0f);
				fontItem.print(220, 350, "Green");

				glColor3f(1.0f, 0.0f, 0.0f);
				fontItem.print(471, 350, "red");

				printItem(220, 560, "Up / Down");
				printItem(480, 560, "Page 1/3");
			}
			if ( currentItem == 1 )
			{
				printTitle(200, 200, "How to Play");
				printItem(220, 230, "The fevermeter multiplies the score with");
				printItem(220, 250, "the current fever level. From 1x up to 16x!");
				printItem(220, 270, "Note that errors will decrease the fever.");
				printItem(220, 300, "The number above a word shows how much");
				printItem(220, 320, "the score will increase or decrease.");
				printItem(220, 350, "indicates an erronous one. Backspace is");

				printItem(220, 560, "Up / Down");
				printItem(480, 560, "Page 2/3");
			}
			if ( currentItem == 2 )
			{
				printTitle(200, 200, "How to Play");
				printItem(220, 230, "How score is calculated:");
				printItem(240, 260, "WordPoints = ( correct * 10 - wrong * 7");
				printItem(240, 280, "                     - empty * 5 ) * length");
				printItem(220, 310, "After this, the score is increased as follows:");
				printItem(240, 340, "Score += WordPoints * speed * difficulty");
				printItem(240, 360, "               * feverlevel");

				printItem(220, 560, "Up / Down");
				printItem(480, 560, "Page 3/3");
			}
		}
		else if ( currentMenu == MENU_CREDITS )
		{
			printTitle(200, 200, "Credits");
			printItem(250, 250, "Coding and design:");
			printItem(280, 280, "Fredrik Asgard aka Unleeb");

			printItem(250, 320, "Graphics:");
			printItem(280, 350, "Fredrik Asgard aka Unleeb");
			printItem(295, 370, "Kim Berg aka Kimmels");

			printItem(250, 410, "Sound and Music:");
			printItem(280, 440, "Fredrik Asgard aka Unleeb");
			printItem(315, 460, "Powered by FMOD");

			printItem(250, 500, "Idea:");
			printItem(280, 530, "Andreas <etternavn> aka Zpider");
		}
		else if ( currentMenu == MENU_EXIT )
		{
			printTitle(200, 200, "Exit");
			printItem(260, 250, "Are you sure you want to exit?");
			printItem(340, 280, "Yes / No");
		}
	}

	void fMenu::update()
	{

	}

}