
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

#include "fFeverMeter.h"

namespace fingers
{

	fFeverMeter::fFeverMeter()
	{
		max = 100;
	}

	void fFeverMeter::addFever(int score)
	{
		amount += score / 25;
	}

	int fFeverMeter::getFeverLevel()
	{
		int level = amount/502 * 4;

		level = (level > 4) ? 4 : level;

		switch ( level )
		{
		case 0:
			return 1;
		case 1:
			return 2;
		case 2:
			return 4;
		case 3:
			return 8;
		case 4:
			return 16;
		}

		return 1;
	}

	void fFeverMeter::render(unsigned int texture)
	{
		float top = (590 - amount) > 88 ? (590 - amount) : 88;

		glPushMatrix();
		glLoadIdentity();
		gluOrtho2D(0.0f, 800.0f, 600.0f, 0.0f);

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		glColor4f(1.0f, 0.0f, 0.0f, 0.5f);
		glBegin(GL_QUADS);
			glVertex2f(15.0f, top);
			glVertex2f(45.0f, top);
			glVertex2f(45.0f, 590.0f);
			glVertex2f(15.0f, 590.0f);
		glEnd();

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, texture);

		glColor3f(1.0f, 1.0f, 1.0f);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 1.0f); glVertex2f(  5.0f, 83.0f);
			glTexCoord2f(1.0f, 1.0f); glVertex2f(101.0f, 83.0f);
			glTexCoord2f(1.0f, 0.0f); glVertex2f(101.0f, 595.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex2f(  5.0f, 595.0f);
		glEnd();

		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);

		glPopMatrix();
	}

	void fFeverMeter::update(float dt)
	{
		if ( amount > 0 )
			amount -= dt;
		else
			amount = 0;
	}

}