
#include <windows.h>
#include "timer.h"

timer_c::timer_c()
{
	LARGE_INTEGER fFrequency;

	// Get the CPU frequency
	QueryPerformanceFrequency(&fFrequency);
	
	// Calculate the time factor
	factor = 1.0f / fFrequency.QuadPart;

	reset();
}

void timer_c::reset()
{
	LARGE_INTEGER iTime;

	// Get the system time
	QueryPerformanceCounter(&iTime);

	// Calculate system-wide time for the first frame
	start = (float)iTime.QuadPart * factor;
}

void timer_c::update()
{
	LARGE_INTEGER iTime;

	// Store the old time
	oldtime = time;

	// Get the system time
	QueryPerformanceCounter(&iTime);

	// Calculate system-wide time
	time = (float)iTime.QuadPart * factor - start;

	// And calculate the time since last frame
	delta = time - oldtime;
}