varying vec3 v1;
varying vec3 v2;
varying vec3 norm;
varying vec3 pos;

uniform sampler2D tex0;
uniform sampler2D tex1;

void main ()
{
	vec4 frag = texture2D(tex0, gl_TexCoord[0].st);
	vec3 nmap = texture2D(tex1, gl_TexCoord[0].st).xyz;
	vec3 npos = normalize(pos);
	mat3 ts = mat3(normalize(v1), normalize(v2), normalize(norm));
	float diffuse, specular, reflected;
	float att, dist;

	dist = length(pos);
	att =  1.0 / (0.05*dist);// + (0.0008*dist*dist));

	nmap = nmap * vec3(2.0) - vec3(1.0);
	nmap = ts * normalize(nmap);
	nmap = normalize(nmap);

	diffuse = max(dot(nmap, npos), 0.0);

	gl_FragColor = frag * diffuse;
}