/* A Timekeeper based on Javascript date objects */

function Timer() {
}
Timer.prototype.load = function() {
	this.localStartTime = 0;
	this.playing = false;
	var result = new Deferred();
	result.setResult(true);
	return result;
}
Timer.prototype.play = function() {
	this.globalStartTime = (new Date()).getTime();
	this.playing = true;
}
Timer.prototype.pause = function() {
	this.localStartTime = this.currentTime();
	this.playing = false;
}
Timer.prototype.currentTime = function() {
	if (this.playing) {
		return this.localStartTime + ((new Date()).getTime() - this.globalStartTime);
	} else {
		return this.localStartTime;
	}
}
Timer.prototype.duration = function() {
	return 180000;
}
Timer.prototype.seek = function(t) {
	this.localStartTime = t;
	this.globalStartTime = (new Date()).getTime();
	var result = new Deferred();
	result.setResult(true);
	return result;
}
