ImageLoader = function(images) {
	this.images = images;
	this.opts = {};
	this.type = 'imageloader';
}
ImageLoader.images = {};
ImageLoader.prototype.loadImage = function(id, src) {
	var result = new Deferred();
	ImageLoader.images[id] = new Image();
	ImageLoader.images[id].onload = function() {
		result.setResult(true);
	}
	ImageLoader.images[id].src = src;
	return result;
}
ImageLoader.prototype.load = function() {
	var loaders = [];
	for (image in this.images) {
		loaders.push(this.loadImage(image, this.images[image]));
	}
	if (loaders.length == 0) {
		return true;
	} else {
		return deferUntilAllCompleted(loaders);
	}
}
ImageLoader.prototype.toScript = function() {
	return "new ImageLoader(" + JSON.stringify(this.images) + ')';
}
