/* Object representing a result that may not be available yet. */
function Deferred() {
	this.completed = false;
	this.result = null;
	this.listeners = [];
}
/* Called by the creator of this object to announce that a result is available. */
Deferred.prototype.setResult = function(result) {
	if (this.completed) return; /* don't allow result to be set multiple times */
	this.result = result;
	this.completed = true;
	for (var i = 0; i < this.listeners.length; i++) {
		this.listeners[i](result);
	}
}
/* Register a callback to be called when this result is available
(or immediately, if it's available now). */
Deferred.prototype.complete = function(listener) {
	if (this.completed) {
		listener(this.result);
	} else {
		this.listeners.push(listener);
	}
}

/* Given an array of objects, return a Deferred which will return true
only after any Deferred objects among them have completed. */
function deferUntilAllCompleted(args) {
	var overallResult = new Deferred();
	var needToDefer = false;
	for (var i = 0; i < args.length; i++) {
		if (args[i] instanceof Deferred) {
			needToDefer = true;
			args[i].complete(function() {
				for (var j = 0; j < args.length; j++) {
					if (args[j] instanceof Deferred && !args[j].completed) {
						return;
					}
				}
				overallResult.setResult(true);
			})
		}
	}
	if (!needToDefer) overallResult.setResult(true);
	return overallResult;
}
