
//-------------------------------------------------------------------
// O[op[^
//-------------------------------------------------------------------
float4x4 shWorldMat;
float4x4 shViewMat;
float4x4 shVProjMat;

float  shRate : TIME_RATE;


// eNX`
sampler2D shTexture0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};

sampler2D shTexture1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};

//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void strapVS(	float4 in_pos 			: POSITION,
				float3 in_norm   		: NORMAL,
				float4 in_col 			: COLOR0,
				float2 in_texcoord 		: TEXCOORD0,
				out float4 out_pos 		: POSITION,
				out float4 out_col		: COLOR0,
				out float2 out_texcoord : TEXCOORD0,
				float3 Tangent  : TANGENT0
				)
{
	out_pos			= mul( shVProjMat, in_pos );
	out_col			= in_col;
	out_texcoord	= in_texcoord;
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void strapPS(	float4 in_col		: COLOR,
				float2 samplePos	: TEXCOORD0,
				out float4 out_col	: COLOR
				)
{
	//float4 texCol0 = tex2D( shTexture0, samplePos );
	//float4 texCol1 = tex2D( shTexture1, samplePos );

	// color
	//out_col = texCol0 * texCol1 * in_col;
	out_col = in_col;
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		// 
		BlendEnable			= true;
		BlendFunc			= int2( SrcAlpha, One );
		DepthMask			= false;
		DepthTestEnable		= true;

		VertexProgram   = compile glslv strapVS();
		FragmentProgram = compile glslf strapPS();
	}

	pass P1
	{
		// 
		BlendEnable			= true;
		BlendFunc			= int2( SrcAlpha, OneMinusSrcAlpha );
		DepthMask			= false;
		DepthTestEnable		= true;

		VertexProgram   = compile glslv strapVS();
		FragmentProgram = compile glslf strapPS();
	}
}
