float4x4 shVProjMat;

sampler2D shScreenTexture = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

void defaultVS(float4 in_pos 			: POSITION,
				float2 in_texcoord		: TEXCOORD0,
				out float4 out_pos 		: POSITION,
				out float2 out_texcoord : TEXCOORD0
				)
{
	out_pos = mul(shVProjMat, in_pos);
	out_texcoord = in_texcoord;
}

void outputScreenPS(float2 samplePos : TEXCOORD0,out float4 out_col : COLOR)
{
	out_col = tex2D(shScreenTexture, samplePos);
}

void fillBlackPS(out float4 out_col : COLOR)
{
	out_col = float4(0, 0, 0, 1);
}

technique sm_glsl
{
	pass P0
	{
		VertexProgram   = compile glslv defaultVS();
		FragmentProgram = compile glslf outputScreenPS();
	}
	pass P1
	{
		VertexProgram   = compile glslv defaultVS();
		FragmentProgram = compile glslf fillBlackPS();
	}
}
