//-------------------------------------------------------------------
// ftHgVF[_[ for MQO
//-------------------------------------------------------------------
//-------------------------------------------------------------------
// O[op[^
//-------------------------------------------------------------------
float4x4 shWorldMat;
float4x4 shViewMat;
float4x4 shVProjMat;
float4 shDiffuse;
float3 shAmbient;
float3 shEyePos;

float3 shLightColor;
float3 shLightPos;

float3 shKe;	// emission
float3 shKa;	// ambient
float3 shKd;	// diffuse
float3 shKs;	// specular
float  shShininess;

float  shRate : TIME_RATE;

//-------------------------------------------------------------------
// MQOp[^
//-------------------------------------------------------------------
// J[
float4 shMqoColor;

// eNX`[ ͗l ]
sampler2D shBaseTexture = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};
// eNX`[  ]
sampler2D shOverlapTexture = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};

#define NO_LIGHTING_DEBUG (1)// CeBO𖳌ɂ

//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void defaultVS(float4 in_pos 			: POSITION,
				float3 in_norm   		: NORMAL,
				float4 in_col 			: COLOR0,
				float2 in_texcoord 		: TEXCOORD0,
				out float4 out_pos 		: POSITION,
				out float4 out_col		: COLOR0,
				out float2 out_texcoord : TEXCOORD0,
				float3 Tangent  : TANGENT0
				)
{
	//pos
	out_pos = mul(shVProjMat, in_pos);
	
#if NO_LIGHTING_DEBUG==0
	float3 w_normal = normalize(mul((float3x3)shWorldMat, in_norm));
	float4 tmpLight    = float4(0.0, 1.0, 1.0, 0.0);
	float4 tmpAmbient  = float4(0.2, 0.2, 0.2, 1.0);
	float3 tmpCol      = max(dot(w_normal, tmpLight), 0.0);
	tmpCol = tmpCol + tmpAmbient.xyz;
	out_col = float4(tmpCol, 1.0);
	out_col = out_col * shMqoColor;
#else
	//out_col = in_col;
	out_col = shMqoColor;
#endif

	//texcoord
	out_texcoord = in_texcoord;
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void defaultPS(float4 in_col : COLOR,
			float2 samplePos : TEXCOORD0,
			out float4 out_col : COLOR
			)
{
	// color
	out_col = tex2D(shBaseTexture, samplePos) * in_col;
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		// 
		AlphaBlendEnable = true;
		BlendFunc = int2(SrcAlpha, OneMinusSrcAlpha);

		VertexProgram   = compile glslv defaultVS();
		FragmentProgram = compile glslf defaultPS();
	}
}
