//-------------------------------------------------------------------
// EnvVF[_[ for MQO
//-------------------------------------------------------------------
//-------------------------------------------------------------------
// O[op[^
//-------------------------------------------------------------------
float4x4 shWorldMat;
float4x4 shViewMat;
float4x4 shVProjMat;
float4 shDiffuse;
float3 shAmbient;
float3 shEyePos;

float3 shLightColor;
float3 shLightPos;

float3 shKe;	// emission
float3 shKa;	// ambient
float3 shKd;	// diffuse
float3 shKs;	// specular
float  shShininess;

float  shRate : TIME_RATE;

//-------------------------------------------------------------------
// MQOp[^
//-------------------------------------------------------------------
// J[
float4 shMqoColor;

// eNX`[ ͗l ]
sampler2D shBaseTexture = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};
// eNX`[  ]
sampler2D shOverlapTexture = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};

sampler2D shima = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};

sampler2D refCube = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};

#define NO_LIGHTING_DEBUG (1)// CeBO𖳌ɂ

//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void defaultVS(float4 in_pos 			: POSITION,
				float3 in_norm   		: NORMAL,
				float3 in_col 			: COLOR0,
				float2 in_texcoord 		: TEXCOORD0,
				out float4 out_pos 		: POSITION,
				out float4 out_col		: COLOR0,
				out float2 out_texcoord : TEXCOORD0,
				out float3 out_N		: TEXCOORD1,
				out float3 out_E		: TEXCOORD2
				)
{
	//pos
	out_pos = mul(shVProjMat, in_pos);
	out_N =normalize( mul((float3x3)shViewMat, mul((float3x3)shWorldMat, in_norm)) );
	
	float4 wpos = mul(shViewMat, mul(shWorldMat, in_pos));
	out_E = normalize((wpos - shEyePos).xyz);
	out_col = shMqoColor;
	out_texcoord = in_texcoord;
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void defaultPS(float4 in_col : COLOR0,
			float2 samplePos : TEXCOORD0,
			float3 in_N   : TEXCOORD1,
			float3 in_E   : TEXCOORD2,
			out float4 out_col : COLOR
			)
{
	// color
	float3 refvec = reflect(in_E, in_N) - 0.5f;
	out_col = (pow(tex2D(refCube, -refvec)*1.5f,5.0f) + 0.2f) * tex2D(shBaseTexture, samplePos) * in_col;
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		// 
		//AlphaBlendEnable = true;
		//BlendFunc = int2(SrcAlpha, OneMinusSrcAlpha);

		VertexProgram   = compile glslv defaultVS();
		FragmentProgram = compile glslf defaultPS();
	}
}
