uniform float explosion;
uniform float time;
uniform float extra;

varying vec3 onormal;


void main() {
  vec4 vertex  = gl_Vertex;
  onormal = gl_Normal;
    
  vertex.x += gl_Normal.x * explosion;	
  vertex.y += gl_Normal.y * explosion;	
  vertex.z += gl_Normal.z * explosion;	

  


  gl_Position = gl_ModelViewProjectionMatrix * vertex;


  vec3 normal, lightDir;
  vec4 diffuse;
  float NdotL;
  

  normal = normalize(gl_NormalMatrix * gl_Normal);

  lightDir = normalize(vec3(gl_LightSource[0].position));

  NdotL = max(dot(normal, lightDir), 0.0);
  
  diffuse = extra*(gl_Color * normal.z) /  (1.0+gl_Position.z); //* gl_LightSource[0].diffuse;
  diffuse.a = 1.0;
  gl_FrontColor =  diffuse;

}
