#include "_shared.fx"

float4x4 wvpMatrix : WorldViewProjection;

DepthStencilState EnableDepth
{
    DepthEnable = TRUE;
    DepthWriteMask = ALL;
    DepthFunc = LESS_EQUAL;
	StencilEnable = false;
};

RasterizerState rsWireframe
{ 
    FillMode = WireFrame; 
};

float4 RenderSceneVS( float3 vPos : POSITION ) : SV_POSITION
{
    return mul(float4(vPos,1.0f), wvpMatrix);
}

float4 RenderScenePS( float4 Pos : SV_POSITION ) : SV_TARGET
{ 
	return float4(1.0f, 0.0f, 0.0f, 1.0f);
}

technique10 Wireframe
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );

        SetDepthStencilState( EnableDepth, 0 );
		SetRasterizerState( rsWireframe );
    }
}