#include "_shared.fx"

Texture2D<float4> image;

struct VS_INPUT
{
    float3 Position 	: POSITION;
	float2 uvCoord0		: TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord0	: TEXCOORD0;
};
struct PS_OUTPUT
{
	float4 color : SV_Target;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
	Out.Position = float4(In.Position,1.0f);
	Out.uvCoord0 = In.uvCoord0;
    return Out;
}

float4 RenderScenePS( VS_OUTPUT In ) : SV_Target
{
	float red = (fftData.Load(int3(50+sin(In.uvCoord0.x*100.0f)*10.0f,0,0))+fftData.Load(int3(50+sin(In.uvCoord0.y*100.0f)*10.0f,0,0)))*100.0f;
	return max(0.5f,min(red,1.0f))*image.Sample(LinearSampler,In.uvCoord0);
}

technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
		SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );

		SetDepthStencilState( NoDepth, 0 );
		SetRasterizerState( NotMultisampled );
		SetBlendState( NoBlending, float4(0,0,0,0), 0xffffffff );
    }
}