#include "_shared.fx"

float4x4 wvpMatrix : WorldViewProjection;
float ColA;

Texture2D<float4> image;

struct VS_INPUT
{
    float3 Position 	: POSITION;
	float2 uvCoord		: TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord0	: TEXCOORD0;
};
struct PS_OUTPUT
{
	float4 color : SV_Target;
};

VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
	
	Out.Position = mul(float4(In.Position,1.0f),wvpMatrix);
	Out.uvCoord0 = In.uvCoord;
    return Out;
}

float4 RenderScenePS( VS_OUTPUT In ) : SV_Target
{
	return image.Sample(LinearSampler,In.uvCoord0)*ColA;
}

technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
		SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
    }
}