#include "_shared.fx"

float4 ambient1;
float4 ambient2;
float4 ambient3;
float ColA;
float ColR;

float4x4 wvpMatrix 	: WorldViewProjection;

struct VS_INPUT
{
    float3 vPos : POSITION;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float4 color : TEXCOORD0;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);
	Out.color = lerp(ambient1,lerp(ambient2,ambient3,ColR),ColA-length(In.vPos)/34.0f);
    return Out;
}

float4 RenderScenePS( VS_OUTPUT In ) : SV_Target
{ 
    return In.color;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetBlendState( NoBlending, float4(0,0,0,0), 0xffffffff );
    }
}