#include "_shared.fx"

Texture2D image;

float4x4 wvpMatrix 	: WorldViewProjection;

struct VS_INPUT
{
    float3 vPos : POSITION;
	float2 uvCoord : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord : TEXCOORD0;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);
	Out.uvCoord = In.uvCoord;
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	Out.finalColor = image.Sample(PointSampler,In.uvCoord);

    return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetBlendState( Blending, float4(0,0,0,0), 0xffffffff );
    }
}