#include "_shared.fx"

float4 g_MaterialAmbientColor = { 0.0f, 0.0f, 0.0f, 1.0f };

float4x4 wvpMatrix 	: WorldViewProjection;

struct VS_INPUT
{
    float3 vPos : POSITION;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);

    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	Out.finalColor = g_MaterialAmbientColor;

    	return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( Depth, 0 );
		SetBlendState( NoBlending, float4(0,0,0,0), 0xffffffff );
		SetRasterizerState( Multisampled );
    }
}