/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.circuits.Reverb1Element;

public class Reverb1
extends SynthCircuit {
    static final int NUM_ELEMENTS = 6;
    Reverb1Element[] delays = new Reverb1Element[6];
    MultiplyAddUnit myMixer;
    BusReader busIn;
    double[] times = new double[]{0.05, 0.056, 0.061, 0.068, 0.072, 0.078};
    SynthBusInput busInput;
    SynthInput dryGain;

    public Reverb1() throws SynthException {
        this.busIn = new BusReader();
        this.add(this.busIn);
        this.myMixer = new MultiplyAddUnit();
        this.add(this.myMixer);
        int n = 0;
        while (n < this.delays.length) {
            Reverb1Element reverb1Element;
            this.delays[n] = reverb1Element = new Reverb1Element(this.times[n]);
            this.add(reverb1Element);
            this.busIn.output.connect(reverb1Element.input);
            reverb1Element.amplitude.set(0.15);
            if (n > 0) {
                this.delays[n - 1].output.connect(this.delays[n].mix);
            }
            ++n;
        }
        this.busIn.output.connect(this.myMixer.inputA);
        this.delays[5].output.connect(this.myMixer.inputC);
        this.busInput = this.busIn.busInput;
        this.addPort(this.busInput);
        this.dryGain = this.myMixer.inputB;
        this.addPort(this.dryGain, "dryGain");
        this.output = this.myMixer.output;
        this.addPort(this.output);
        this.dryGain.set(0.7);
        this.compile();
    }
}

