/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.Filter_1o1z;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSample;

public class MultiTapDelay
extends SynthCircuit {
    SynthSample delayLine;
    SampleReader_16F1[] unitReaders;
    BusWriter[] busWriters;
    BusReader busReader;
    SampleWriter_16F1 unitWriter;
    Filter_1o1z averager;
    MultiplyAddUnit feedbackMixer;
    int numSamples;
    int numTaps;
    public SynthInput input;
    public SynthInput feedback;
    public SynthOutput output;

    double findLargestDouble(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (d < dArray[n]) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public MultiTapDelay(double[] dArray, double[] dArray2) throws SynthException {
        this.numTaps = dArray.length;
        double d = this.findLargestDouble(dArray) + 0.01;
        this.numSamples = (int)(d * Synth.getFrameRate());
        this.delayLine = new SynthSample(this.numSamples);
        this.unitWriter = new SampleWriter_16F1();
        this.add(this.unitWriter);
        this.feedbackMixer = new MultiplyAddUnit();
        this.add(this.feedbackMixer);
        this.busReader = new BusReader();
        this.add(this.busReader);
        this.averager = new Filter_1o1z();
        this.add(this.averager);
        this.unitReaders = new SampleReader_16F1[this.numTaps];
        this.busWriters = new BusWriter[this.numTaps];
        int n = 0;
        while (n < dArray.length) {
            this.unitReaders[n] = new SampleReader_16F1();
            this.add(this.unitReaders[n]);
            this.busWriters[n] = new BusWriter();
            this.add(this.busWriters[n]);
            this.unitReaders[n].output.connect(this.busWriters[n].input);
            this.unitReaders[n].amplitude.set(dArray2[n]);
            this.busWriters[n].busOutput.connect(this.busReader.busInput);
            int n2 = (int)(dArray[n] * Synth.getFrameRate());
            this.unitReaders[n].samplePort.queue(this.delayLine, this.numSamples - n2, n2);
            this.unitReaders[n].samplePort.queueLoop(this.delayLine, 0, this.numSamples);
            ++n;
        }
        this.unitWriter.samplePort.queueLoop(this.delayLine, 0, this.numSamples);
        this.busReader.output.connect(this.averager.input);
        this.averager.output.connect(this.feedbackMixer.inputA);
        this.feedbackMixer.output.connect(this.unitWriter.input);
        this.input = this.feedbackMixer.inputC;
        this.addPort(this.input, "input");
        this.feedback = this.feedbackMixer.inputB;
        this.addPort(this.feedback, "feedback");
        this.output = this.busReader.output;
        this.addPort(this.output);
    }
}

