/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ChunkHandler;
import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.ParseIFF;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SynthSampleAIFF
extends SynthSample
implements ChunkHandler {
    static final int AIFF_ID = 1095321158;
    static final int AIFC_ID = 1095321155;
    static final int COMM_ID = 1129270605;
    static final int SSND_ID = 1397968452;
    static final int MARK_ID = 1296126539;
    static final int INST_ID = 1229869908;
    static final int NONE_ID = 1313820229;

    public SynthSampleAIFF(SynthContext synthContext, InputStream inputStream) throws SynthException, IOException {
        super(synthContext);
        this.load(inputStream);
    }

    public SynthSampleAIFF(SynthContext synthContext) {
        super(synthContext);
    }

    public SynthSampleAIFF(InputStream inputStream) throws SynthException, IOException {
        this.load(inputStream);
    }

    public SynthSampleAIFF() {
    }

    public short[] loadShorts(InputStream inputStream, boolean bl) throws SynthException, IOException {
        short[] sArray = null;
        this.ifLoadData = bl;
        this.parser = new ParseIFF(inputStream);
        this.parser.parse(this);
        if (bl && this.numFrames > 0) {
            sArray = this.convertBigBytesToShorts();
        }
        this.parser = null;
        return sArray;
    }

    double read80BitFloat() throws IOException {
        byte[] byArray = new byte[10];
        this.parser.read(byArray);
        int n = (byArray[0] & 0x3F) << 8 | byArray[1] & 0xFF;
        int n2 = (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        return (double)n2 / (double)(1 << 22 - n);
    }

    void parseCOMMChunk(ParseIFF parseIFF, int n) throws IOException {
        int n2;
        this.channelsPerFrame = parseIFF.readShortBig();
        this.numFrames = parseIFF.readIntBig();
        short s = parseIFF.readShortBig();
        if (s != 16) {
            throw new IOException("Only 16 bit samples supported.");
        }
        this.setSampleRate(this.read80BitFloat());
        if (n > 18 && (n2 = parseIFF.readIntBig()) != 1313820229) {
            throw new IOException("Compression not supported, format " + ParseIFF.IDToString(n2));
        }
    }

    void parseINSTChunk(ParseIFF parseIFF, int n) throws IOException {
        byte by = parseIFF.readByte();
        byte by2 = parseIFF.readByte();
        this.setBaseFrequency(EqualTemperedTuning.getMIDIFrequency(by, by2));
        by = parseIFF.readByte();
        this.setLowFrequency(EqualTemperedTuning.getMIDIFrequency(by));
        by = parseIFF.readByte();
        this.setHighFrequency(EqualTemperedTuning.getMIDIFrequency(by));
        parseIFF.skip(2L);
        short s = parseIFF.readShortBig();
        short s2 = parseIFF.readShortBig();
        short s3 = parseIFF.readShortBig();
        short s4 = parseIFF.readShortBig();
        this.setSustainLoop(this.findCuePosition(s3), this.findCuePosition(s4));
        s2 = parseIFF.readShortBig();
        s3 = parseIFF.readShortBig();
        s4 = parseIFF.readShortBig();
        this.setReleaseLoop(this.findCuePosition(s3), this.findCuePosition(s4));
    }

    void parseSSNDChunk(ParseIFF parseIFF, int n) throws IOException {
        long l;
        int n2 = parseIFF.readIntBig();
        parseIFF.readIntBig();
        parseIFF.skip(n2);
        this.dataPosition = parseIFF.getOffset();
        int n3 = n - 8 - n2;
        if (this.ifLoadData) {
            this.byteData = new byte[n3];
            l = parseIFF.read(this.byteData);
        } else {
            l = parseIFF.skip(n3);
        }
        if (l != (long)n3) {
            throw new EOFException("AIFF data chunk too short!");
        }
    }

    void parseMARKChunk(ParseIFF parseIFF, int n) throws IOException {
        int n2 = parseIFF.readShortBig();
        int n3 = 0;
        while (n3 < n2) {
            short s = parseIFF.readShortBig();
            int n4 = parseIFF.readIntBig();
            int n5 = parseIFF.read();
            if ((n5 & 1) == 0) {
                ++n5;
            }
            parseIFF.skip(n5);
            this.insertSortedCue(new CuePoint(n4, s));
            ++n3;
        }
    }

    public void handleForm(ParseIFF parseIFF, int n, int n2, int n3) throws IOException {
        if (n == 1179603533 && n3 != 1095321158 && n3 != 1095321155) {
            throw new IOException("Bad AIFF form type = " + ParseIFF.IDToString(n3));
        }
    }

    public void handleChunk(ParseIFF parseIFF, int n, int n2) throws IOException {
        switch (n) {
            case 1129270605: {
                this.parseCOMMChunk(parseIFF, n2);
                break;
            }
            case 1397968452: {
                this.parseSSNDChunk(parseIFF, n2);
                break;
            }
            case 1296126539: {
                this.parseMARKChunk(parseIFF, n2);
                break;
            }
            case 1229869908: {
                this.parseINSTChunk(parseIFF, n2);
                break;
            }
        }
    }
}

