
static const float shadowBias = 4.0;


struct ShadowVertexInput {
	float3 oPosition: POSITION;
};


struct ShadowPixelInput {
	float4 pPosition: POSITION;
	float3 wPosition: TEXCOORD0;
};


struct ShadowPixelOutput {
	float4 color: COLOR;
};


ShadowPixelInput ShadowDepthVS(ShadowVertexInput input) {
	// transform position
	float4 oPosition = float4(input.oPosition, 1);
	float4 wPosition = mul(oPosition, matObjectToWorld);
	float4 pPosition = mul(wPosition, matWorldToCubeFace);
	
	// create output
	ShadowPixelInput output = (ShadowPixelInput)0;
	output.pPosition = pPosition;
	output.wPosition = wPosition;
	return output;
}


ShadowPixelOutput ShadowDepthPS(ShadowPixelInput input) {
	ShadowPixelOutput output;
	float dist = distance(lightPosition, input.wPosition);
	output.color = dist;
	return output;
}


float ComputeShadow(samplerCUBE depthCube, float3 direction, float lightDist) {
	float4 shadowDist = texCUBE(depthCube, direction).r;
	return lightDist < (shadowDist+shadowBias);
}


float CalculateSoftShadow(samplerCUBE depthCube, float3 wLightDir, float lightDist) {
#ifdef SHOW_SHADOWS
	static const int quality = shadowQuality;
	static const float radius = softShadowsRadius;
	float realDistance = lightDist;
	
	float sum = 0;
	for (int i = 0; i < quality; i++) {
		float3 dir = wLightDir;
		dir += unitSphere[i] * radius;
		sum += ComputeShadow(depthCube, dir, realDistance);
	}
	return sum / quality;
#else
	return 0;
#endif
}
