#!/usr/bin/cube

open /dev/ttyUSB1
	
proc phase1 {} {
	clear
	led 2 4 2 8
	flush
	sleep 250
	led 3 4 1 8
	led 1 4 3 8
	flush
	sleep 250
	led 4 4 0 8
	led 0 4 4 8
	flush
	sleep 250
	for {set y 3} {$y >= 0} {incr y -1} {
		led 4 $y 0 8	
		led 0 $y 4 8
		flush
		sleep 250
	}
	for {set y 3} {$y >= 0} {incr y -1} {
		led 1 $y 3 8
		led 3 $y 1 8
	}
	flush
	sleep 250
	for {set y 3} {$y >= 0} {incr y -1} {
		led 2 $y 2 8
	}
	flush
	sleep 250
	clear
	for {set x 0} {$x < 5} {incr x} {
		for {set y 0} {$y < 5} {incr y} {
			led $x $y 2 8
		}
	}
	flush
	sleep 250
	clear
	for {set x 0} {$x < 5} {incr x} {
		for {set y 0} {$y < 5} {incr y} {
			led $x $y $x 8
		}
	}
	flush
	sleep 250
	clear
	for {set z 0} {$z < 5} {incr z} {
		for {set y 0} {$y < 5} {incr y} {
			led 2 $y $z 8
		}
	}
	flush
	sleep 250
	clear
	set x 0
	set z 4
	for {set i 0} {$i < 5} {incr i} {
		for {set y 0} {$y < 5} {incr y} {
			led $x $y $z 8
		}
		incr x
		incr z -1
	}
	flush
	sleep 250
	for {set y 0} {$y < 4} {incr y} {
		led 2 $y 2 0	
	}	
	flush
	sleep 250
	for {set y 0} {$y < 4} {incr y} {
		led 1 $y 3 0	
		led 3 $y 1 0	
	}	
	flush
	sleep 250
	for {set y 0} {$y < 4} {incr y} {
		led 0 $y 4 0	
		led 4 $y 0 0	
		flush
		sleep 250
	}	
	led 4 4 0 0
	led 0 4 4 0
	flush
	sleep 250
	led 3 4 1 0
	led 1 4 3 0
	flush
	sleep 250
	led 2 4 2 0
	flush
}

proc phase2 {} {
	for {set x 0} {$x < 5} {incr x} {
		led $x 0 0 8
		led $x 1 0 8
		led $x 2 0 8
		led $x 3 0 8
		led $x 4 0 8
		flush
		sleep 50
	}
	for {set z 1} {$z < 5} {incr z} {
		led 4 0 $z 8
		led 4 1 $z 8
		led 4 2 $z 8
		led 4 3 $z 8
		led 4 4 $z 8
		flush	
		sleep 50
	}
	for {set x 3} {$x >= 0} {incr x -1} {
		led $x 0 4 8
		led $x 1 4 8
		led $x 2 4 8
		led $x 3 4 8
		led $x 4 4 8
		flush
		sleep 50
	}
	for {set z 3} {$z >= 1} {incr z -1} {
		led 0 0 $z 8
		led 0 1 $z 8
		led 0 2 $z 8
		led 0 3 $z 8
		led 0 4 $z 8
		flush
		sleep 50
	}
	for {set x 1} {$x < 4} {incr x} {
		led $x 0 1 8
		led $x 1 1 8
		led $x 2 1 8
		led $x 3 1 8
		led $x 4 1 8
	}
	for {set z 2} {$z < 4} {incr z} {
		led 3 0 $z 8
		led 3 1 $z 8
		led 3 2 $z 8
		led 3 3 $z 8
		led 3 4 $z 8
		flush
		sleep 50
	}
	for {set x 2} {$x >= 1} {incr x -1} {
		led $x 0 3 8
		led $x 1 3 8
		led $x 2 3 8
		led $x 3 3 8
		led $x 4 3 8
		flush	
		sleep 50
	}
	for {set x 1} {$x < 3} {incr x} {
		led $x 0 2 8
		led $x 1 2 8
		led $x 2 2 8
		led $x 3 2 8
		led $x 4 2 8
		flush
		sleep 50
	}
}


proc phase3 {} {
	for {set y 4} {$y >= 0} {incr y -1} {
		for {set x 0} {$x < 5} {incr x} {
			led $x $y 0 0
			led $x $y 0 0
			led $x $y 0 0
			led $x $y 0 0
			led $x $y 0 0
			flush
			sleep 50
		}
		for {set z 1} {$z < 5} {incr z} {
			led 4 $y $z 0
			led 4 $y $z 0
			led 4 $y $z 0
			led 4 $y $z 0
			led 4 $y $z 0
			flush	
			sleep 50
		}
		for {set x 3} {$x >= 0} {incr x -1} {
			led $x $y 4 0
			led $x $y 4 0
			led $x $y 4 0
			led $x $y 4 0
			led $x $y 4 0
			flush
			sleep 50
		}
		for {set z 3} {$z >= 1} {incr z -1} {
			led 0 $y $z 0
			led 0 $y $z 0
			led 0 $y $z 0
			led 0 $y $z 0
			led 0 $y $z 0
			flush
			sleep 50
		}
		for {set x 1} {$x < 4} {incr x} {
			led $x $y 1 0
			led $x $y 1 0
			led $x $y 1 0
			led $x $y 1 0
			led $x $y 1 0
		}
		for {set z 2} {$z < 4} {incr z} {
			led 3 $y $z 0
			led 3 $y $z 0
			led 3 $y $z 0
			led 3 $y $z 0
			led 3 $y $z 0
			flush
			sleep 50
		}
		for {set x 2} {$x >= 1} {incr x -1} {
			led $x $y 3 0
			led $x $y 3 0
			led $x $y 3 0
			led $x $y 3 0
			led $x $y 3 0
			flush	
			sleep 50
		}
		for {set x 1} {$x < 3} {incr x} {
			led $x $y 2 0
			led $x $y 2 0
			led $x $y 2 0
			led $x $y 2 0
			led $x $y 2 0
			flush
			sleep 50
		}
	}
}

proc fall_right { time } {
	for {set z 1} {$z <= 10} {incr z} {
		for {set x 0} {$x <= 4} {incr x} {
			set temp $z
			for {set y 0} {$y <= 4} {incr y} {
				set temp [ expr $temp - 1 ]
				if {$temp >= 0 && $temp <= 4 && $y >= 0 && $y <= 4} {
					led $x $y $temp 8
				} elseif { $temp <= 0 } {
					led $x $y 0 8 
				} elseif { $temp >= 4 } {
					led $x $y 4 8
				}
			}
			set temp [ expr $temp + 4 ]
		}
		sleep $time
		flush
		clear
	}
}

proc fall_left { time } { 
	for {set z 2} {$z >= -5} {incr z -1} {
		for {set x 0} {$x <= 4} {incr x} {
			set temp $z
			for {set y 0} {$y <= 4} {incr y} {
				set temp [ expr $temp + 1 ]
				if {$temp >= 0 && $temp <= 4 && $y >= 0 && $y <= 4} {
					led $x $y $temp 8
				} elseif { $temp <= 0 } {
					led $x $y 0 8 
				} elseif { $temp >= 4 } {
					led $x $y 4 8
				}
			}
			set temp [ expr $temp - 4 ]
		}
		sleep $time
		flush
		clear
	}
}

proc phase4 {} {
clear
flush

set LINES 2
set TOT 10
set TIME 150


for {set i 3} {$i <= 10} {incr i} {
	set a($i,x) 5
	set a($i,y) 5
	set a($i,z) 5
}

set c 1

for {set j 1} {$j <= 100} {incr j} {
	
	if {$c == 1} {
		for {set i 1} {$i <= $LINES} {incr i} {
			set x [rand 0 5]
			set z [rand 0 5]
			set a($i,x) $x
			set a($i,y) 4
			set a($i,z) $z
		}
	}

	if {$c == 2} {
		for {set i 3} {$i <= [expr $LINES+2]} {incr i} {
			set x [rand 0 5]
			set z [rand 0 5]
			set a($i,x) $x
			set a($i,y) 4
			set a($i,z) $z
		}
	}

	if {$c == 3} {
		for {set i 5} {$i <= [expr $LINES+4]} {incr i} {
			set x [rand 0 5]
			set z [rand 0 5]
			set a($i,x) $x
			set a($i,y) 4
			set a($i,z) $z
		}
	}

	if {$c == 4} {
		for {set i 7} {$i <= [expr $LINES+6]} {incr i} {
			set x [rand 0 5]
			set z [rand 0 5]
			set a($i,x) $x
			set a($i,y) 4
			set a($i,z) $z
		}
	}

	if {$c == 5} {
		for {set i 9} {$i <= [expr $LINES+8]} {incr i} {
			set x [rand 0 5]
			set z [rand 0 5]
			set a($i,x) $x
			set a($i,y) 4
			set a($i,z) $z
		}
	}

	for {set i 1} {$i <= $TOT} {incr i} {
		if {$a($i,x) != 5} {
			if {$a($i,y) >= 0} {
				led $a($i,x) $a($i,y) $a($i,z) 8
			}
			if {$a($i,y) <= 3 && $a($i,y) >= -1} {
				
				led $a($i,x) [expr $a($i,y)+1] $a($i,z) 4
			}
			if {$a($i,y) <= 2 && $a($i,y) >= -2} {
				led $a($i,x) [expr $a($i,y)+2] $a($i,z) 4
			}
			if {$a($i,y) <= 1 && $a($i,y) >= -3} {
				led $a($i,x) [expr $a($i,y)+3] $a($i,z) 0
			}
		}
		incr a($i,y) -1
	}

	if {$c < 9} {incr c}
	if {$c == 9} {set c 1}

	sleep $TIME
	flush
	}
}

proc phase5 {} {
set LEDS 7

clear
flush

for {set y 0} {$y < 5} {incr y} {
	if {$y > 0} {
		if {[expr $y-1] > 0} {
			led 2 [expr $y-2] 2 0
			flush
		}
		led 2 [expr $y-1] 2 1
		flush
	}	
	led 2 $y 2 8
	flush
	sleep 300
}
set p 15
for {set x 0} {$x < 5} {incr x} {
	for {set y 0} {$y < 5} {incr y} {
		for {set z 0} {$z < 5} {incr z} {
			led $x $y $z $p
		}
	}
}
flush
sleep 200
for {set p 15} {$p >= 0} {incr p -1} {
	for {set x 0} {$x < 5} {incr x} {
		for {set y 0} {$y < 5} {incr y} {
			for {set z 0} {$z < 5} {incr z} {
				led $x $y $z $p
			}
		}
	}
	flush
}

for {set x 1} {$x < 4} {incr x} {
	for {set z 1} {$z < 4} {incr z} {
		led $x 4 $z 8
	}
}
flush
sleep 500
for {set p 0} {$p < 9} {incr p} {
	for {set x 1} {$x < 4} {incr x} {
		led $x 3 0 $p
	}	
	for {set z 1} {$z < 4} {incr z} {
		led 0 3 $z $p
	}
	for {set x 1} {$x < 4} {incr x} {
		led $x 3 4 $p
	}
	for {set z 1} {$z < 4} {incr z} {
		led 4 3 $z $p
	}
	sleep 75
	flush
}
for {set p 10} {$p >= 0} {incr p -1} {
	for {set x 1} {$x < 4} {incr x} {
		for {set z 1} {$z < 4} {incr z} {
			led $x 4 $z [expr $p-2]
		}
	}
	set r [led 2 2 2]
	for {set x 1} {$x < 4} {incr x} {
		for {set z 1} {$z < 4} {incr z} {
			led $x 2 $z [expr $r+1]
		}	
	}	
	flush
	for {set x 1} {$x < 4} {incr x} {
		led $x 3 0 $p
	}	
	for {set z 1} {$z < 4} {incr z} {
		led 0 3 $z $p
	}
	for {set x 1} {$x < 4} {incr x} {
		led $x 3 4 $p
	}
	for {set z 1} {$z < 4} {incr z} {
		led 4 3 $z $p
	}
	sleep 75
	flush
}	

for {set i 0} {$i <= 5} {incr i} {
	for {set n 0} {$n <= $LEDS} {incr n} {
		set a($n,x) [rand 0 5]
		set a($n,y) [rand 0 2]
		set a($n,z) [rand 0 5]
		while {$a($n,x) == 2 && $a($n,z) == 2} {
			set a($n,x) [rand 0 5]
			set a($n,z) [rand 0 5]
		}
		set a($n,p) [rand 3 7]
		led $a($n,x) $a($n,y) $a($n,z) $a($n,p)
	}
	flush
	for {set p 8} {$p >= 0} {incr p -1} {
		if {[led 2 2 2] > 0} {
			for {set x 1} {$x < 4} {incr x} {
				for {set z 1} {$z < 4} {incr z} {
					led $x 2 $z $p
				}
			}
			flush
		}
		for {set n 0} {$n <= $LEDS} {incr n} {
			led $a($n,x) $a($n,y) $a($n,z) $p
		}
		flush
	}
}
}

phase1
phase2
phase3
for {set x 0} {$x < 10} {incr x} {
	fall_right 60
	fall_left 60
}
phase4
phase5

