float fWidth = 800;
float fHeight = 600;

float4 vColor;	

float fSizeX = 16;
float fSizeY = 16;
float fBeat = 1;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Point; MagFilter = Point;
};

texture tMask;
sampler smpMask = sampler_state {
    Texture = <tMask>;    
    MipFilter = None; MinFilter = Point; MagFilter = Point;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	o.pos = float4( i.pos.x / fWidth * 2 - 1, i.pos.y / fHeight * 2 - 1, i.pos.z, 1 );
	o.tex = i.tex * 0.8 + float2(0.02, 0.07 );
	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 
	float4 col = tex2D( smpBase, i.tex );
	//float4 mask = tex2D( smpMask, float2(i.tex.x * 64 / 4, i.tex.y * 48 / 4) );
	float4 mask = tex2D( smpMask, float2(i.tex.x * fSizeX, i.tex.y * fSizeY) );

	//mask.rgb = mask.a;
	//mask.a = 1;
	//return col;

	float a = mask.a - (fBeat * 0.99);
	a = clamp(a * 1000, 0.6, 1);

	//float a = max(mask.a, 0.5);
	//float a = max(mask.a, 0.6);

	col.rgb = col.rgb * (1 - a) + mask.rgb * a;
	//col.r = mask.a;

	//col.rgb = a;
	//col.a = 1;

	return col;
} 


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
		
		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;

		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}

	