float fWidth = 8;
float fHeight = 6;

float4 vColor;
float4x4 mWorld;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};

//texture tBlur0;
//texture tBlur1;
texture tBlur2;
texture tBlur3;
texture tBlur4;
texture tBlur5;
//texture tBlur6;
//texture tBlur7;

//sampler smpBlur0 = sampler_state { Texture = <tBlur0>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };
//sampler smpBlur1 = sampler_state { Texture = <tBlur1>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };
sampler smpBlur2 = sampler_state { Texture = <tBlur2>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };
sampler smpBlur3 = sampler_state { Texture = <tBlur3>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };
sampler smpBlur4 = sampler_state { Texture = <tBlur4>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };
sampler smpBlur5 = sampler_state { Texture = <tBlur5>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };
//sampler smpBlur6 = sampler_state { Texture = <tBlur6>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };
//sampler smpBlur7 = sampler_state { Texture = <tBlur7>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; };

struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
	float2 tex2 : TEXCOORD1;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	float4 pos = mul( i.pos, mWorld );
	o.pos = float4( pos.x / fWidth * 2, pos.z / fHeight * 2, -pos.y / 10 + 0.5, 1 );
	o.tex = i.tex;
	o.tex2 = o.pos.xy * 0.5 + 0.5;
	o.tex2.y = -o.tex2.y;
	//o.tex2.x += 0.3;
	//o.tex2.x += 0.01;
	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 
	float4 col = tex2D( smpBase, i.tex );
	
	//float4 bg = tex2D( smpBackground, i.tex2 );
	
	float4 bg = (
//		tex2D( smpBlur0, i.tex2 ) + 
//		tex2D( smpBlur1, i.tex2 ) + 
		tex2D( smpBlur2, i.tex2 ) + 
		tex2D( smpBlur3, i.tex2 ) +
		tex2D( smpBlur4, i.tex2 ) + 
		tex2D( smpBlur5, i.tex2 ) 
//		tex2D( smpBlur6, i.tex2 ) + 
//		tex2D( smpBlur7, i.tex2 ) 
	) / 4;

	//bg = tex2D( smpBlur5, i.tex2 );

	

	bg *= col;
	//col.rgb += 0.2 * bg.r;

	bg.rgb += 0.3 * col.r;

	return bg;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
	
		ZEnable = False;
		ZWriteEnable = False;		

		CullMode = None; 

		AlphaBlendEnable = False;
		//AlphaBlendEnable = True;
		//SrcBlend = SrcAlpha;
		//DestBlend = InvSrcAlpha;		
	}
}

	