float fWidth = 800 * 0.01f;
float fHeight = 600 * 0.01f;

float4 vColor;
float4x4 mWorld;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};

texture tMask;
sampler smpMask = sampler_state {
    Texture = <tMask>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	float4 pos = mul( i.pos, mWorld );
	o.pos = float4( pos.x / fWidth * 2, pos.z / fHeight * 2, -pos.y / 10 + 0.5, 1 );
	o.tex = (o.pos.xy + 1) / 2;
	o.tex.y = -o.tex.y;
	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 
	float4 col = tex2D( smpBase, i.tex );
	float4 mask = tex2D( smpMask, i.tex );

	col.a = mask.r;
	//col.rgb = mask.rgb;

	return col;
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
	
		ZEnable = False;
		ZWriteEnable = False;		

		CullMode = None; 

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		

	}
}

	