float4x4 mVP;	// View * Projection matrix

float4 vColor;
float4x4 mWorld;

float3 vLight = {0, -20, -30};
float3 vEyePos = {0, 0, 0};
float4 vBgCol;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	float4 pos = mul( i.pos, mWorld );
	o.pos = mul( pos, mVP );
	o.tex = i.tex;

	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 
	float4 col = tex2D( smpBase, i.tex );
	col.a = col.r * vColor.a;
	col.rgb = 0;

	return col;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
	
		ZEnable = True;
		ZWriteEnable = False;
		CullMode = None;

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}

	