float fWidth = 800;
float fHeight = 600;

float4 vColor;

texture tBase;

texture tBlur0;
texture tBlur1;
texture tBlur2;
texture tBlur3;
texture tBlur4;
texture tBlur5;

sampler smpBlur0 = sampler_state { Texture = <tBlur0>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; AddressU = Clamp; AddressV = Clamp; };
sampler smpBlur1 = sampler_state { Texture = <tBlur1>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; AddressU = Clamp; AddressV = Clamp; };
sampler smpBlur2 = sampler_state { Texture = <tBlur2>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; AddressU = Clamp; AddressV = Clamp; };
sampler smpBlur3 = sampler_state { Texture = <tBlur3>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; AddressU = Clamp; AddressV = Clamp; };
sampler smpBlur4 = sampler_state { Texture = <tBlur4>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; AddressU = Clamp; AddressV = Clamp; };
sampler smpBlur5 = sampler_state { Texture = <tBlur5>; MipFilter = None; MinFilter = Linear; MagFilter = Linear; AddressU = Clamp; AddressV = Clamp; };

struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	//float4 pos = mul( i.pos, mWorld );
	//o.pos = float4( pos.x / fWidth * 2, pos.z / fHeight * 2, 0, 1 );
	o.pos = float4( i.pos.x / fWidth * 2 - 1, i.pos.y / fHeight * 2 - 1, i.pos.z, 1 );
	o.tex = i.tex;
	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 	
	//float4 c = tex2D( smpBlur0, i.tex );
	//c.rbg = c.a;
	//c.a = 1;
	//return c;

/*	float4 bg = (
		//tex2D( smpBlur0, i.tex )
		  tex2D( smpBlur1, i.tex ) 
		+ tex2D( smpBlur2, i.tex ) 
//		+ tex2D( smpBlur3, i.tex ) 
//		+ tex2D( smpBlur4, i.tex ) 
//		+ tex2D( smpBlur5, i.tex ) 
	) / 2;
//	bg = 1;
	return bg;*/

	float2 tex = i.tex + float2(-0.014, -0.01);

	float a = (tex2D( smpBlur1, tex ).a + tex2D( smpBlur2, tex ).a) / 2;
	float4 col;
	col.rgb = 0;
	col.a = a * 0.8;

	return col;

}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
	
		ZEnable = False;
		ZWriteEnable = False;		

		CullMode = None; 

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		
	}
}

	