#include "ZenitShared.fx"

texture tEnv;
texture tBase;
texture tNorm;

sampler BaseSampler = sampler_state {
    Texture = <tBase>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};

sampler EnvSampler = sampler_state {
    Texture = <tEnv>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};

sampler NormSampler = sampler_state {
    Texture = <tNorm>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
        float2 tex : TEXCOORD0;
	float3 binormal : TEXCOORD1;
	float3 tangent : TEXCOORD2;
	float2 texe : TEXCOORD3;
};

struct SOutput
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
	float2 texe : TEXCOORD1;
	float3 normal : TEXCOORD2;
	float3 binormal : TEXCOORD3;
	float3 tangent : TEXCOORD4;
	float3 posWorld : TEXCOORD5;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 pos;
	
	gSkinning( i.pos, i.normal, i.binormal, i.tangent, i.index, 
		     pos, o.normal, o.binormal, o.tangent );
	
	o.posWorld = pos;
	o.pos = mul( float4( pos, 1 ), mVP );
		
	o.tex = i.tex; 
	o.texe = i.texe;

	//o.tangent = -cross( o.normal, o.binormal );
	//o.binormal = cross( o.normal, o.tangent );
	//o.tangent = -cross( o.normal, o.binormal );

	//o.normal = i.normal;
	//o.binormal = i.binormal;
	//o.tangent = i.tangent;
	
	return o;   
}


float4 RenderScenePS( SOutput i ) : COLOR
{ 
	//float3x3 mTangentFrame = { i.tangent, i.binormal, i.normal };
	float3x3 mTangentFrame = { i.binormal, i.tangent, i.normal };
	//mTangentFrame = transpose( mTangentFrame );
	float3 normal = tex2D( NormSampler, i.tex ) * 2 - 1;
	//normal = float3( 1, 1, 1 );
	float3 normalWorld = normalize( mul( normal, mTangentFrame ) );

	//normalWorld = lerp( normalWorld, i.normal, 0.5 );

	float3 toPos = i.posWorld - vCameraPos;
	float3 reflection = normalize( reflect( toPos, normalWorld ) );
	float2 texe = {
		 reflection.x * 0.5 / 16 + 0.5 / 16 + i.texe.x,
		-reflection.y * 0.5 + 0.5
	};

	//float4 diffuse = gLightDiffuse * max( 0, dot( normalWorld, gLightDir ) ) + gLightAmbient;
	float4 diffuse = 
		gLightDiffuse * max( 0, dot( normalWorld, gLightDir ) ) * 0.5
		+ i.texe.y + gLightAmbient;

	//return float4( float3( 0, -1, 0 ) * 0.5 + 0.5, 1 );
	//return dot( i.normal, float3( 0, -1, 0 ) ) * 0.5 + 0.5;

/*	return float4( 
		abs( dot( i.normal, i.binormal ) ),
		abs( dot( i.normal, i.tangent ) ),
		abs( dot( i.binormal, i.tangent ) ),
		1
	);     */

	//return float4( normalWorld * 0.5 + 0.5, 1 );
	//return float4( 0, normalWorld.z * 0.5 + 0.5, 0, 1 );
	//return float4( normal * 0.5 + 0.5, 1 );
	//return float4( i.normal * 0.5 + 0.5, 1 );
	//return float4( i.binormal * 0.5 + 0.5, 1 );
	//return float4( i.tangent * 0.5 + 0.5, 1 );
	//return float4( abs( i.normal ), 1 );
	//return float4( abs( i.binormal ), 1 );
	//return float4( abs( i.tangent ), 1 );
	//return float4( abs( normal ), 1 );
	//return float4( abs( normalWorld ), 1 );
	//return float4( texe.x * 16 * 0.5 + 0.5, texe.y * 0.5 + 0.5, 0, 1 );
	//return float4( i.tex.x, i.tex.y, 0, 1 );

	//return diffuse;

	
	return  tex2D( EnvSampler, texe ) * 0.5 +
		tex2D( BaseSampler, i.tex ) * diffuse;

	//return i.texe.y * 2;

	//return  tex2D( EnvSampler, texe ) * 0.5 +
	//	tex2D( BaseSampler, i.tex ) * i.texe.y * 2;

	//return diffuse;
}


technique RenderScene {
	pass P0 {          
//		VertexShader = compile vs_1_1 RenderSceneVS();
//		PixelShader  = compile ps_1_1 RenderScenePS();
		VertexShader = compile vs_2_0 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
		
		AlphaBlendEnable = False;
		ZEnable = True;
		ZWriteEnable = True;
		//CullMode = CCW;
		CullMode = <iCull>;
	}
}

	