#include "ZenitShared.fx"

texture tSlice;

float fShiftX;
float fShiftY;

float4 vColor;

sampler SliceSampler = sampler_state {
    Texture = <tSlice>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
};

struct SOutput
{
	float4 pos : POSITION;
	float2 texs : TEXCOORD0;
	float tex : TEXCOORD1;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 pos;
	
	gSkinning( i.pos, i.index, pos );	
	
	o.pos = mul( float4( pos, 1 ), mVP );
		
	o.texs.x = fShiftX * 0.3;
	o.texs.y = pos.y * 0.05 + fShiftY * 0.5;

	o.tex = clamp((length(pos - vCameraPos) - 14) / 20, 0, 1);

	return o;   
}


float4 RenderScenePS( SOutput i ) : COLOR
{ 
	float4 col = vColor;
	//float4 col = float4(1,1,1,1);
	col.a = tex2D( SliceSampler, i.texs ).a;
	//col.rgb *= i.tex;
	return col;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_1_1 RenderScenePS();
		
		ZEnable = True;
		ZWriteEnable = True;
		//CullMode = <iCull>;
		CullMode = None;

		//AlphaBlendEnable = True;
		AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		
		
		AlphaTestEnable = True;
		AlphaFunc = Greater;
		AlphaRef = 100;
	}
}
