#include "ZenitShared.fx"


struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
};

struct SOutput
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 pos, normal;
	
	gSkinning( i.pos, i.normal, i.index, pos, normal );	
	
	float3 toPos = pos - vCameraPos;
		
	o.pos = mul( float4( pos, 1 ), mVP );
		
	o.diffuse.rgb = normal;
	float f = 1-abs( dot( normalize( normal ), normalize( toPos ) ) );
	o.diffuse.a = f * f * f * 0.1 + 0.05;
//	o.diffuse.a = 0.1;

//	o.diffuse.rgb = f * f;
//	o.diffuse.a = f * f * f;

	return o;   
}


float4 RenderScenePS( SOutput i ) : COLOR
{ 
	return i.diffuse;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_1_1 RenderScenePS();
		
		
		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;
	
		AlphaTestEnable = False;
		AlphaBlendEnable = True;
//		SrcBlend = SrcAlpha;
		SrcBlend = One;
//		DestBlend = InvSrcAlpha;
		DestBlend = One;

	}
}

	