#include "ZenitShared.fx"

texture tEnv;
texture tBase;

//float fTime;
float4x4 mBooleanObj;

sampler BaseSampler = sampler_state {
    Texture = <tBase>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};

sampler EnvSampler = sampler_state {
    Texture = <tEnv>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};

struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
        float2 tex : TEXCOORD0;
	float2 texe : TEXCOORD1;
};

struct SOutput
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
	float2 tex : TEXCOORD0;
	float3 texe : TEXCOORD1;
	float3 posw : TEXCOORD2;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 pos, normal;
	
	gSkinning( i.pos, i.normal, i.index, pos, normal );	
	
	float3 toPos = pos - vCameraPos;
	float3 reflection = normalize( reflect( toPos, normal ) );
	o.texe = float3(
		 reflection.x * 0.5 / 16 + 0.5 / 16 + i.texe.x,
		-reflection.y * 0.5 + 0.5, 
		i.texe.y
	);
	
	o.pos = mul( float4( pos, 1 ), mVP );
		
	o.tex = i.tex; 
	
	o.diffuse = gLightDiffuse * max( 0, dot( normal, gLightDir ) ) + gLightAmbient;

	o.diffuse.a = dot( normalize( toPos ), normal ) + 0.5;

	o.posw = pos;

	return o;   
}


float4 RenderScenePS( SOutput i )
{ 
	float4 col = i.diffuse;

	float3 spos = mBooleanObj[3].xyz;
	//float sr = 5;
	float sr = mBooleanObj[0][3];

	float3 vd = i.posw - spos;
	float d = length( vd );

	// sphere
	col.a = min( 1, d / sr );
	// plane
	//col.a = min( 1, abs( vd.y ) / sr * 3 );
	// rotating plane
	//col.a = min( 1, abs( dot( mBooleanObj[0].xyz, vd ) ) / sr * 3 );
	// box
	/*col.a = min( 1, max( max( 
		abs( vd.x ) / sr, 
		abs( vd.y ) / sr ),
		abs( vd.z ) / sr )
	);*/
	// rotating box
	/*col.a = min( 1, max( max( 
		abs( dot( mBooleanObj[0].xyz, vd ) ) / sr, 
		abs( dot( mBooleanObj[1].xyz, vd ) ) / sr ),
		abs( dot( mBooleanObj[2].xyz, vd ) ) / sr )
	);*/
	return col;
}

float4 RenderScenePSCW( SOutput i ) : COLOR
{
	float4 col = RenderScenePS( i );

	col.rgb = float3( 0.8, 0, 0 );
	//col.rgb = gLightDiffuse * max( 0, dot( -vd / d, gLightDir ) ) + gLightAmbient;
	
	//col.rgb *= tex2D( BaseSampler, i.tex ).rgb +
	//	     tex2D( EnvSampler, i.texe );

	return col;
}

float4 RenderScenePSCCW( SOutput i ) : COLOR
{
	float4 col = RenderScenePS( i );

//	float3 tcol = tex2D( BaseSampler, i.tex ).rgb +
//	   tex2D( EnvSampler, i.texe );

//	col.rgb *= tex2D( BaseSampler, i.tex ).rgb +
//		   tex2D( EnvSampler, i.texe );

	col.rgb = i.texe.z * 1.5;
	

	//float4 aocol = i.texe.z;
//	float f = 0.5;
//	col.rgb = aocol.rgb * f + tcol.rgb * (1 - f);

	return col;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePSCCW();
		
		ZEnable = True;
		ZWriteEnable = True;
		CullMode = CCW;

		AlphaBlendEnable = False;
		
		AlphaTestEnable = True;
		AlphaFunc = Greater;
		AlphaRef = 254;
	}
	pass P1 { 
		VertexShader = compile vs_1_1 RenderSceneVS();         
		PixelShader  = compile ps_2_0 RenderScenePSCW();
		
		CullMode = CW;
	}
}
