#ifndef __SCREEN_LAYER_SHARED_FX
#define __SCREEN_LAYER_SHARED_FX

float fWidth = 8;
float fHeight = 6;

float4x4 mVP;	// View * Projection matrix

float4 vColor;
float4x4 mWorld;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};

struct SPosTex {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SPosTex transformVP( SPosTex i )
{
	SPosTex o;

	float4 pos = mul( i.pos, mWorld );
	o.pos = mul( pos, mVP );
	o.tex = i.tex;

	return o; 
}

SPosTex transform2D( SPosTex i )
{
	SPosTex o;
	float4 pos = mul( i.pos, mWorld );
	o.pos = float4( pos.x / fWidth * 2, pos.z / fHeight * 2, -pos.y / 10 + 0.5, 1 );
	//o.tex = (o.pos.xy + 1) / 2;
	//o.tex.y = -o.tex.y;
	o.tex = i.tex;
	return o; 
}

float4 psTex( SPosTex i ) : COLOR
{
	return tex2D( smpBase, i.tex );
}

float4 psTexCol( SPosTex i ) : COLOR
{
	return tex2D( smpBase, i.tex ) * vColor;
}


#endif