float4x4 g_mWorld;					// World matrix for object
float4x4 g_mWorldViewProjection;	// World * View * Projection matrix

texture g_MeshTexture;

// NOTE : not used but referenced from DX code so we keep them here
float4 g_MaterialDiffuseColor;
float4 g_MaterialAmbientColor;
float3 g_LightDir;


sampler BaseSampler = sampler_state {
    Texture = <g_MeshTexture>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};

struct SInput {
	float4 pos : POSITION;
        float3 normal : NORMAL;
        float2 tex : TEXCOORD0;
};

struct SOutput
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
	float2 tex : TEXCOORD1;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;

        float3 pos = i.pos * 10;


	//o.pos = mul( float4( pos, 1 ), g_mWorld );
	o.pos = mul( float4( pos, 1 ), g_mWorldViewProjection );
	//o.pos = mul( i.pos, g_mWorldViewProjection );
	//o.pos = i.pos;
	o.diffuse = 0;
	o.diffuse.r = 1;

	o.tex = 0;

	return o;   
}


float4 RenderScenePS( SOutput i ) : COLOR
{ 
	return i.diffuse;
//	return tex2D( BaseSampler, i.tex ) * i.diffuse;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_1_1 RenderScenePS();
		
		AlphaBlendEnable = False;
		ZEnable = True;
		ZWriteEnable = True;
		CullMode = CW;

		ZFunc = Greater;
	}
}

