
#define MAX_INSTRUCTIONS 96
//#define ANTIALIAS

#if MAX_INSTRUCTIONS > 96
	#define ANTIALIAS
#endif

uniform sampler2D tex1;
uniform float time;
uniform float xres;
uniform float yres;

const float m1 = 0.1;
const float m2 = 1.0-m1;

vec2 getUV(vec2 coord, float time) {
	vec2 uv = coord;
	vec3 val1 = texture2D(tex1, uv).rgb;
	vec3 val2 = texture2D(tex1, uv+vec2(0.0, 0.1)).rgb;
//	vec3 val3 = texture2D(tex1, uv+vec2(0.0, 0.2)).rgb;

	float v1 = val1.r;
	float v2 = val2.r;
//	float v3 = val3.r;

//	float lookup = max(v1, max(v2, v3))*0.75;
	float lookup = max(v1, v2);

	return vec2(0.04565*lookup*sin(time*3.85*3.14159+uv.x*14.0*lookup) +
	            0.05525*lookup*sin(time*4.65*1.38572+uv.y*26.0*lookup),
//				0.04565*lookup*sin(time*3.85*3.14159+uv.x*14.0*lookup),
	            0.0285*lookup*sin(time*3.14159+uv.x*uv.y));
}

void main() {

	vec2 c = gl_TexCoord[0].xy;

#ifdef ANTIALIAS
	vec2 uv = c+getUV(c, time);
	vec2 uv_u = c+getUV(vec2(c.x-1.0/xres, c.y), time);
	vec2 uv_r = c+getUV(vec2(c.x+1.0/xres, c.y), time);
	vec2 uv_d = c+getUV(vec2(c.x, c.y+1.0/yres), time);
	vec2 uv_l = c+getUV(vec2(c.x, c.y-1.0/yres), time);

	vec4 finCol = 0.4*texture2D(tex1, uv)+
	              0.15*texture2D(tex1, uv_u)+
	              0.15*texture2D(tex1, uv_r)+
	              0.15*texture2D(tex1, uv_d)+
	              0.15*texture2D(tex1, uv_l);
#else
	vec4 finCol = texture2D(tex1, c+getUV(c, time));
#endif

/*	vec2 uvp = vec2(0.04565*lookup*sin(time*3.85*3.14159+uv.x*14.0*lookup) +
	             0.05525*lookup*sin(time*4.65*1.38572+uv.y*26.0*lookup), 0.0285*lookup*sin(time*3.14159+uv.x*uv.y));
	vec2 uvn = vec2(-uvp.x, uvp.y);
	vec3 col1 = texture2D(tex1, uv+uvp).rgb;
	vec3 col2 = texture2D(tex1, uv+uvn).rgb;

	vec4 finCol = vec4(0.25*max(col1, col2)+0.75*min(col1, col2), 1.0);*/

	gl_FragColor = m1*vec4(texture2D(tex1, c).rgb, 1.0) + m2*finCol;
}