var music;

window.onload = init;

function init() {
  if (getMediaType() == "projection") {
    main(0);
  } else {
    document.addEventListener("keypress", keypressed, false);
  }
};

function getMediaType() {
  if (document.defaultView.getComputedStyle(document.getElementById("media"),'').getPropertyValue("display") == "block") {
    return "screen"; 
  } else {
    return "projection";
  }
}

function keypressed(e) {
  if (e.keyCode == 122 || getMediaType() == "projection") {
    document.removeEventListener("keypress", keypressed,false);
    if (getMediaType() != "projection") {
      document.getElementById("projectionStyle").media+=",screen";
    }
    main(0);
  }
}

function main(state) {
  switch (state) {
  case 0:
    window.WIN_HEIGHT = window.innerHeight;
    window.WIN_WIDTH = window.innerWidth;
    window.WIN_HEIGHT_2 = window.WIN_HEIGHT/2;
    window.WIN_WIDTH_2 = window.WIN_WIDTH/2;  
  init_music();
  break;
  case 1:
  var pf = new Playfield();
  var intro = new Scene(pf,"intro",intro_run,intro_stop,20000);
  var web20 = new Scene(pf,"web",web20_run,web20_stop,5000);
  var starfield = new Scene(pf,"starfield",sf_run,sf_stop,180000);
//  var rotate = new Scene(pf,"rotate",rt_run,rt_stop,180000);
  pf.scenes.push(intro);
  pf.scenes.push(web20);
  pf.scenes.push(starfield);
//  pf.scenes.push(rotate);
  window.setTimeout(function() { pf.start(); }, 2000);
  break;
  default:
  main(0);
  break;
  }
}

function init_music() {
    if (window.Audio) {
      music = new Audio("snd/music.wav");
      music.addEventListener("load",function(){ music.loop(3); main(1); },false);
    } else {
      main(1);
      document.getElementById("media").style.display = "none";
    }
//
//main(1);
}

function stop_music() {
    if(window.music) {
      music.stop();
    }
}

function Scene(pf,id,run_f,stop_f,dur) {
  var self = this;
  this.id = id; 
  this.div = document.createElement("div");
  this.div.id = this.id;
  this.div.className = "scene";
  this.div.style.height = window.innerHeight+"px";
  this.run = run_f;
  this.stop = stop_f;
  this.dur = dur;
  this.onfinish = null;
  this.pf = pf;
}

function Playfield() {
  var self = this;
  this.scenes = new Array();
  this.pf = document.getElementById("playfield");
  this.curScene = null;

  this.start = function() {
    for(var i=0; i<this.scenes.length;i++) {
      if ((i+1) < this.scenes.length) {
        self.scenes[i].next = self.scenes[i+1];
        debug(i+" "+this.scenes.length+" adding scene "+this.scenes[i].id+" next: "+self.scenes[i].next.id);
        this.scenes[i].onfinish = function() { self.stopScene(this); debug("about to run "+this.next.id); self.runScene(this.next);};
      } else {
        debug(i+" "+this.scenes.length+" adding last scene "+this.scenes[i].id+" next: "+self.scenes[i].next);
        this.scenes[i].onfinish = function() { self.stopScene(this);};
      }
    }
    this.runScene(this.scenes[0]);
  }
 
  this.runScene = function(scene) {
    debug("Starting scene: "+scene.id);
    if (this.curScene == null) {
      this.curScene = scene;
      this.pf.appendChild(scene.div);
      if (scene.setup) { scene.setup(); }
//      this.timeout = window.setTimeout(function() { scene.onfinish(); },scene.dur);
      scene.run();
    } else {
      alert("Another scene is running");
    }
  }
  
  this.stopScene = function(scene) {
    debug("Stopping scene: "+scene.id);
    if (this.curScene === scene) {
      scene.stop();
      this.pf.removeChild(scene.div);
      this.curScene = null;
//      window.clearTimeout(.timeout);
      this.timeout = null;
      //if (scene.onfinish) { scene.onfinish(); }
      scene = null;
    } else {
      alert("This scene is not running");
    }
  }
}

function newText(text) {
  var txt = document.createElement("div");
  txt.appendChild(document.createTextNode(text)); 
  return txt;
}

function debug(text) {
  if (window.opera && opera.postError) {
    opera.postError(text);
  }
} 