--- objective ---------------------------------------------------------
--
--    flip the bike 5 times
--
-----------------------------------------------------------------------

app = GetApplication();
space = app:GetSpace();
level = GetLevel();

app:SetBgImage("res\\forest.png");
app:SetQueryUpdate(false);
SetLevelTime(300);

-- set bike position
bike = GetBike();
bike:MoveTo(200, -200);

AddObjective("flip the bike 5 times");

-- create some blue clouds
space:Insert(CreateCloud("res\\cloud2.png", 0.0, 0.5, 0, 0.5, 0.5));
space:Insert(CreateCloud("res\\cloud2.png", 0.0, -0.5, 0, 0.5, 0.7));


block = CreateBlock(0, 0, 512, 64, "", false);
block:SetFillColor(37, 183, 71, 200);
space:Insert(block);
block = CreateBlock(-256, -256, 256, 256, "", false);
block:SetFillColor(222, 144, 43, 200);
space:Insert(block);

SetVariable("flip", "0");
EventVariableTriggered("flip", "5", "SetVariable('completed');");

flipevent = CreateEventFlipped();
RegisterEvent(null, flipevent, "IncreaseVariable('flip');", false);
driver = space:FindObject("driver");
EventYGreater(driver, 200, "RestartLevel();");
level:Add(CreateVariableCondition("completed"));



