--- objective ---------------------------------------------------------
--
--    collect 4 stars
--
-----------------------------------------------------------------------
app = GetApplication();
space = app:GetSpace();
level = GetLevel();

app:SetBgImage("res\\sea2.png");

-- set bike position
bike = GetBike();
bike:MoveTo(-1500, 300);

AddObjective("collect 4 stars");

block = CreateBlock(-1784, 400, 512, 120, "", false);
block:SetFillColor(107, 62, 31, 255);
space:Insert(block);
block = CreateBlock(-1272, 400, 512, 120, "", false);
block:SetFillColor(107, 62, 31, 255);
space:Insert(block);

space:Insert(CreateRope(40, -350, 400, -20, 400, 331.36, 10000, 120, 107, 62, 31, 255, 0, 50, 200, 100));
--plant
space:Insert(CreateSprite("res\\plant1.png", 8, 64, 128, 8, 400.0, -300, 350, true));
space:Insert(CreateSprite("res\\plant1.png", 8, 64, 128, 8, 300.0, -150, 360, true));
--water
space:Insert(CreateWater(-350, 400, 330, 130));

space:Insert(CreateRope(40, -760, 400, -430, 400, 331.36, 10000, 120, 107, 62, 31, 255, 0, 50, 200, 100));
--plant
space:Insert(CreateSprite("res\\plant1.png", 8, 64, 128, 8, 400.0, -710, 350, true));
space:Insert(CreateSprite("res\\plant1.png", 8, 64, 128, 8, 300.0, -560, 360, true));
--water
space:Insert(CreateWater(-760, 400, 330, 130));

-- starting area
space:Insert(CreateBlock(20, 432, 50, 50, "res\\wood50x50.png", false));
space:Insert(CreateBlock(20, 400, 512, 32, "res\\wood512x32.png", false));
space:Insert(CreateBlock(532, 400, 512, 32, "res\\wood512x32.png", false));
space:Insert(CreateBlock(994, 432, 50, 50, "res\\wood50x50.png", false));

block = CreateBlock(20, 482, 1024, 38, "", false);
block:SetFillColor(107, 62, 31, 255);
space:Insert(block);
block = CreateBlock(70, 432, 924, 50, "", false);
block:SetFillColor(0, 0, 255, 150);
space:Insert(block);

-- bridge area in the middle
space:Insert(CreateLine(1044, 400, 1329, 234, "res\\wood330x15.png"));
space:Insert(CreateLine(1329, 234, 1532, 494, "res\\wood330x15.png"));

-- right of the bridge
space:Insert(CreateBlock(1532, 494, 512, 32, "res\\wood512x32.png", false));
space:Insert(CreateBlock(2044, 494, 512, 32, "res\\wood512x32.png", false));
space:Insert(CreateBlock(2506, 526, 50, 50, "res\\wood50x50.png", false));
space:Insert(CreateBlock(1532, 526, 50, 50, "res\\wood50x50.png", false));

block = CreateBlock(1532, 576, 1024, 20, "", false);
block:SetFillColor(107, 62, 31, 255);
space:Insert(block);
block = CreateBlock(1582, 526, 924, 50, "", false);
block:SetFillColor(0, 0, 255, 150);
space:Insert(block);

-- upper blocks
space:Insert(CreateBlock(1564, 91, 30, 15, "res\\brick30x15.png", false));
space:Insert(CreateBlock(1536, 106, 512, 32, "res\\wood512x32.png", false));
space:Insert(CreateBlock(652, 59, 512, 32, "res\\wood512x32.png", false));

ship_x = {1700, 200};
ship_y = {305, 211};
for i = 1, 2 do
  sailboat = CreateSprite("res\\sailboat.png", 2, 256, 256, 4, 300.0, ship_x[i], ship_y[i], true);
  sailboat:SetSpeed(-3, 0);
  sailboat:EnableSail(true);
  sailboat:SetSail(ship_x[i] - 50, ship_y[i], ship_x[i] + 500, ship_y[i]);
  space:Insert(sailboat, 9999, null);
end

-- create some blue clouds
space:Insert(CreateCloud("res\\cloud.png", 0.0, 0.2, 0, 0.1, 0.2));

-- create events
driver = space:FindObject("driver");

-- end level if the player falls
EventYGreater(driver, 700, "RestartLevel();");

star1 = CreateLevelStar("star1", 1600, 430);
star2 = CreateLevelStar("star2", 2500, 430);
star3 = CreateLevelStar("star3", 2000, 50);
star4 = CreateLevelStar("star4", 700, 0);

space:Insert(star1);
space:Insert(star2);
space:Insert(star3);
space:Insert(star4);

level:Add(CreateVariableCondition("star1"));
level:Add(CreateVariableCondition("star2"));
level:Add(CreateVariableCondition("star3"));
level:Add(CreateVariableCondition("star4"));


