--- objective ---------------------------------------------------------
--
--    collect 2 stars
--    keep the front wheel up
--
-----------------------------------------------------------------------

app = GetApplication();
space = app:GetSpace();
level = GetLevel();

app:SetBgImage("res\\sunrisemountain.png");
app:SetQueryUpdate(false);
SetLevelTime(180);

-- set bike position
bike = GetBike();
bike:MoveTo(750, 310);

AddObjective("collect 2 stars");
AddObjective("keep the front wheel off the ground");


-- construct the level...
-- ...first create the starting area
space:Insert(CreateBlock(40, 400, 500, 100, "res\\brick500x100.png", false));
start_area = CreateBlock(540, 400, 400, 100, "res\\brick_start400x100.png", false);
space:Insert(start_area, "start_area");
space:Insert(CreateBlock(940, 400, 500, 100, "res\\brick500x100.png", false));

-- ...bridge
space:Insert(CreateLine(1440, 400, 1740, 261, "res\\wood330x15.png"));
space:Insert(CreateLine(1740, 261, 2040, 400, "res\\wood330x15.png"));

-- ...right side of the level
space:Insert(CreateBlock(2040, 400, 500, 100, "res\\brick500x100.png", false));

--
space:Insert(CreateBlock(1800, 0, 500, 100, "res\\brick500x100.png", false));
space:Insert(CreateLine(2663, 648, 2880, 400, "res\\wood330x15.png"));
space:Insert(CreateLine(2401, 848, 2663, 648, "res\\wood330x15.png"));
space:Insert(CreateBlock(1901, 848, 500, 100, "res\\brick500x100.png", false));
--

-- ...bottom of the bridge
space:Insert(CreateBlock(1240, 500, 500, 100, "res\\brick500x100.png", false));
space:Insert(CreateBlock(1740, 500, 500, 100, "res\\brick500x100.png", false));

-- ...add some dynamic objects under the bridge
space:Insert(CreateBlock(1650, 399, 10, 100, "res\\wood10x100.png", true));
space:Insert(CreateBlock(1750, 469, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1745, 453, 30, 15, "res\\brick30x15.png", true));
space:Insert(CreateBlock(1800, 469, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1795, 438, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1800, 407, 15, 30, "res\\brick15x30.png", true));
space:Insert(CreateBlock(1890, 399, 10, 100, "res\\wood10x100.png", true));

-- ...create a block between bridge.
--    anchor the block so it can be detached later
block = CreateBlock(1735, 244, 10, 100, "res\\wood10x100.png", true);
RotateObject(block, 90);
AnchorAt(block, 1690, 286);
AnchorAt(block, 1790, 286);
block:SetMass(2);
space:Insert(block, 0, "piece_of_wood");

-- create events
-- detach the block between the bridge when the driver reaches x = 1450
driver = space:FindObject("driver");
EventXGreater(driver, 1450, "\
  s=app:GetSpace(); \
  o=space:FindObject(\"piece_of_wood\"); \
  o:RemoveUserJoint(0);");
EventXGreater(driver, 1650, "\
  s=app:GetSpace(); \
  o=space:FindObject(\"piece_of_wood\"); \
  o:RemoveUserJoint(0);");
-- end level if the player falls
EventYGreater(driver, 1500, "RestartLevel();");
-- end level if the front wheel collides (anything but the start area)
EventFrontWheelCollision(start_area, "RestartLevel();", true);

-- Add some spriders to make the level more scary ;)
spider = CreateSprite("res\\spider.png", 8, 64, 128, 24, 200, 400, 450, true);
space:Insert(spider);
spider = CreateSprite("res\\spider.png", 8, 64, 128, 24, 300, 1300, 450, true);
space:Insert(spider);

-- add level stars
star1 = CreateLevelStar("star1", 1730, 215);
star2 = CreateLevelStar("star2", 1940, 800);
space:Insert(star1);
space:Insert(star2);
level:Add(CreateVariableCondition("star1"));
level:Add(CreateVariableCondition("star2"));




