float4x4 g_mWorldViewProj;

float g_fTexOffs;

texture g_tTex;
texture g_tEnvMap;

float2 g_f2AngMul;
float2 g_f2DistMul;

sampler Sampler = sampler_state
{
    Texture   = (g_tTex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler EnvSampler = sampler_state
{
    Texture   = (g_tEnvMap);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};



float4 GetVertPos(float2 Pos, float ang, float z)
{
	ang*=3.1415926535897932384626433832795*2;
	
	float4 p=float4(sin(ang), cos(ang), z*15, 1.0);
	
	float2 m;
	m.x= 2+ g_f2DistMul.x * sin(Pos.x+z*15+(g_fTexOffs)*g_f2AngMul.x);
	m.y= 2+ g_f2DistMul.y * sin(Pos.y+z*15+(g_fTexOffs)*g_f2AngMul.y);
	
	p.xy*=m;
	
	return p;
}

void VS(float4 Pos : POSITION, float2 UV : TEXCOORD0, 
					out float4 oPos : POSITION, out float2 oUV : TEXCOORD0, out float2 oUV2 : TEXCOORD1, out float4 oL : COLOR0, out float4 oD : COLOR1)
{
	//Pos.xy*=(0.7+0.2*sin(4*UV.x*3.1459+UV.y*10+g_fTexOffs*10) + 0.2*sin(2*UV.x*3.1459+UV.y*20+g_fTexOffs*20));
	oD=(1-UV.y);
	
	float4 PPP=GetVertPos(Pos.xy, UV.x, UV.y);
	float4 PPZ=GetVertPos(Pos.xy, UV.x, UV.y+0.001);
	float4 PPR=GetVertPos(Pos.xy, UV.x+0.0001, UV.y);
	
	float3 u=normalize(PPZ.xyz-PPP.xyz);
	float3 v=normalize(PPR.xyz-PPP.xyz);
	
	float3 n=normalize(cross(u, v));
	
	oUV2=n.xy*0.5+float2(0.5, 0.5);

	oL=dot(n, normalize(Pos));
	
	oPos=mul(PPP, g_mWorldViewProj);
	UV.y+=g_fTexOffs;
	oUV=UV;
}

float4 PS(float2 UV : TEXCOORD0, float2 UV2 : TEXCOORD1, float4 L : COLOR0, float4 D : COLOR1) : COLOR
{
	//return tex2D(EnvSampler, UV2)*C*3 + tex2D(Sampler, UV)*0.4*C;//float4(1, 1, 1, 1);
	return (tex2D(EnvSampler, UV2)*tex2D(Sampler, UV)+L)*D;//float4(1, 1, 1, 1);
}

technique Standard
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}