var axisRotationOn = false;
var aa1 = new Array(0, 0, 10);
var aa2 = new Array(0, 0, 0);

var starttext_ival = -1;
var helix_ival = -1;
var helix_text_ival = -1;
var bg_ival = -1;
var cc_interval = -1;
var cc_textInterval = -1;
var star_interval = -1;
var star_textInterval = -1;

var black_to_pastel = new Array(
    "#99b2b7", "#97b0b5", "#96afb3", "#95adb2", "#93acb0", "#92aaaf", 
    "#91a9ad", "#90a7ac", "#8ea6aa", "#8da4a9", "#8ca3a7", "#8aa1a6", 
    "#89a0a4", "#889ea3", "#879da1", "#859ba0", "#849a9e", "#83989d", 
    "#82979b", "#80959a").reverse();

function controller() {
    // This is the controller (doh!), which handles starting 
    // and stopping the intervals on specific times.
    starttext_ival = starttext_loader('starttext');
    setTimeout(Control.starttext_stop, 17000);
    setTimeout(Control.helix_start, 17000);
    setTimeout(Control.helix_stop, 35000);
    setTimeout(Control.star_start, 35000);
    setTimeout(Control.change_background, 35000);
    setTimeout(Control.star_stop, 45000);
    setTimeout(Control.cube_start, 45000);
    setTimeout(Control.cube_stop, 98000);
    setTimeout(Control.boid_start, 98000);
    setTimeout(Control.boid_stop, 131000);
    setTimeout(Control.end_start, 131000);
    setTimeout(Control.end_stop, 170000);
}

var canvas = document.getElementsByTagName("svg")[0];

var Control = {
    end_start: function() {
	endtext_loader('kaikki');
    },
    end_stop: function() {
	var kaikkig = document.getElementById('kaikki');
	canvas.removeChild(kaikkig);
    },
    boid_start: function() {
	boid_loader('boids');
    },
    boid_stop: function() {
	clearInterval(blowInterval);
	clearInterval(moveInterval);
	var boidsg = document.getElementById('boids');
	canvas.removeChild(boidsg);
    },
    star_start: function() {
	star_runner('star');
    },
    star_stop: function() {
	clearInterval(star_interval);
	clearInterval(star_textInterval);
	var star = document.getElementById('star');
	var t2 = document.getElementById('t2');
	canvas.removeChild(star);
	canvas.removeChild(t2);
    },
    starttext_stop: function() {
	clearInterval(starttext_ival);
    },
    helix_start: function() {
	helix_ival = helix_loader('helix');
    },
    helix_stop: function() {
	clearInterval(helix_ival);
	var helix = document.getElementById('helix');
	var helixtext = document.getElementById('helixtext');
	canvas.removeChild(helix);
	canvas.removeChild(helixtext);
    },
    change_background: function(arr) {
	setCanvasColor("#99b2b7");
    },
    cube_start: function() {
	crappy_cube_runner();
    },
    cube_stop: function() {
	setCanvasColor("#ffffff");
	clearInterval(cc_interval);
	clearInterval(cc_textInterval);
	var wireframe = document.getElementById('wireframe');
	var t1 = document.getElementById('t1');
	canvas.removeChild(wireframe);
	canvas.removeChild(t1);
    }
}

function crappy_cube_runner() {
    var p0 = new Array(-100, -100, 100);
    var p1 = new Array(100, -100, 100);
    var p2 = new Array(100, 100, 100);
    var p3 = new Array(-100, 100, 100);
    var p4 = new Array(-100, -100, 300);
    var p5 = new Array(100, -100, 300);
    var p6 = new Array(100, 100, 300);
    var p7 = new Array(-100, 100, 300);
    var a1 = new Array(0, 0, 200);
    var a2 = new Array(0, 10, 200);
    var axel = new Array(a1, a2);
    var cube = new Cube(p0, p1, p2, p3, p4, p5, p6, p7, axel);
    cube.increment = 10;
    cc_interval = crappy_cube_loader(cube, 'wireframe');
    var texts = new Array(
	"Spinning wireframe cube, as in every JavaScript demo...",
	"It's just so damn ugly.",
	"But with some tender SVG love..",
	"...we can make it spin smoother and rotate a bit...",
	"...we can have lovely pastel colors...",
	"...we can get rid of the borders...",
	"...and we can make the axis cube spins around spin too!"
    );
    var coords = new Array(
	new Array(-200, 150),
	new Array(200, -150),
	new Array(-500, -200),
	new Array(-600, 200),
	new Array(100, 300),
	new Array(-150, 300),
	new Array(-200, 150)
    );
    textObj = new Text(texts[0], 20, 'Courier', 'black', coords[0]);
    textObj.createSVGRef('t1');

    cc_textInterval = setInterval(shakingText, 100, textObj);
    setTimeout(DemoCube.switchText, 5000, textObj, texts[1], coords[1]);
    setTimeout(DemoCube.switchText, 10000, textObj, texts[2], coords[2]);
    setTimeout(DemoCube.switchText, 15000, textObj, texts[3], coords[3]);
    setTimeout(DemoCube.smoother, 15000, cube);
    setTimeout(DemoCube.switchText, 25000, textObj, texts[4], coords[4]);
    setTimeout(DemoCube.changeFills, 25000, cube, 'wireframe');
    setTimeout(DemoCube.switchText, 35000, textObj, texts[5], coords[5]);
    setTimeout(DemoCube.removeBorders, 35000, cube, 'wireframe');
    setTimeout(DemoCube.switchText, 40000, textObj, texts[6], coords[6]);
    setTimeout(DemoCube.startAxisRotation, 40000);
    
    axelrotator = setInterval(DemoCube.rotateCubeAxel, 40, cube)
}

var bg_iter = 0;

function removeChilds(container_id, childs) {
    for (var i=0; i<childs; i++) {
	document.getElementById(container_id).removeChild(childs[i]);
    }
}

var DemoCube = {
    switchText: function(textObj, text, coords) {
	textObj.text = text;
	textObj.coords = coords;
    },
    smoother: function(cube) {
	cube.angleiter = 0;
	cube.increment = 1;
	cube.spinaxel = new Array(
	    new Array(0, 60, 500),
	    new Array(0, 10, 500)
	);
    },
    changeFills: function(cube, container_id) {
	var colors = new Array(
	    "#D9CEB2", "#D5DED9",
	    "#7A6A53","#D5DED9",
	    "#D9CEB2", "#7A6A53");
	var container = document.getElementById(container_id);
	var objs = container.getElementsByTagName('path');
	for (var i=0; i<cube.polys.length; i++) {
	    cube.polys[i].fill = colors[i];
	    objs[i].setAttributeNS(null, "fill", cube.polys[i].fill);
	}
    },
    removeBorders: function(cube, container_id) {
	var container = document.getElementById(container_id);
	var objs = container.getElementsByTagName('path');
	for (var i=0; i<cube.polys.length; i++) {
	    cube.polys[i].storke = "none";
	    objs[i].setAttributeNS(null, "stroke", "none");
	}
    },
    startAxisRotation: function() {
	axisRotationOn = true;
    },
    rotateCubeAxel: function(cube) {
	if (!axisRotationOn) return;
	rotatePathArbit(cube.spinaxel, aa1, aa2, cube.angleiter*Math.PI/10000);
    },
    stopText: function(interval, text) {
	clearInterval(interval);
	text.text = '';
	text.redraw();
    },
    changebg: function() {
	if (bg_iter >= black_to_pastel.length) {
	    clearInterval(bg_ival);
	}
	setCanvasColor(black_to_pastel[bg_iter++]);
    }
}
