
dofile "data:runtime.lua"

-------------------------------------------------------------------------------
--	utils
-------------------------------------------------------------------------------

function startdmascreen()
	call(-2, do_flipscreen, -1)
	call(-1, do_clearscreen, -1)
	call(5, do_render, -1)
end

function stopdmascreen()
	kill(-2,-1,5)		-- stop flip, clear, render
	do_flipscreen()	-- enforce last dma commit
end

function runpart(dur, part)
	pushtime()
	part()
	waitabs(dur)
	kill(0,1,2,3)
	poptime()
end

function interp_cos(n, ...)
	local step = 0
	return function()
		local c = (cos(pi * step / (n - 1) - pi) * 0.5) + 0.5
		local t = { }
		local j = 1
		for i = 1, #arg / 2 do
			t[i] = c * (arg[j+1] - arg[j]) + arg[j]
			j = j + 2
		end
		if step < n then
			step = step + 1
		end
		return unpack(t)
	end
end

function interp_lin(n, ...)
	local step = 0
	return function()
		local c = step / (n - 1)
		local t = { }
		local j = 1
		for i = 1, #arg / 2 do
			t[i] = c * (arg[j+1] - arg[j]) + arg[j]
			j = j + 2
		end
		if step < n then
			step = step + 1
		end
		return unpack(t)
	end
end

-- provide rhythm as off-peak sawtooth (peaks at clap):

function getclap()
	return 1 - ((rt.absframe - 20) % 60) / 60
end

-- provide rhythm as amplitude/frequency modulated sine:

function getclap2()
	local c = getclap()
	c = c * 1.4
	c = c * c * c * c
 	return sin(c * pi * 2 - pi) * c
end

-------------------------------------------------------------------------------
--	init parts
-------------------------------------------------------------------------------

function init_helvete_part()
	queue(init_helvete)
	queue(init_htext)
	queue(init_htextslot, 0, "neoscientists\n", 13, 2,         14,5,0, 0.00)
	queue(init_htextslot, 1, "\npresent\n", 7, 2,              14,5,0, 0.00)
	queue(init_htextslot, 2, "a ^ demo\ncalled\n", 12, 2,		14,5,0, 0.00)
	return queue(init_htextslot, 3, "innerloop\n", 9, 2,		8.5,4,-10, 0)
end
	
function init_particle_part()
	queue(init_particles)
	queue(init_ptext)
	queue(init_ptextslot, 0, "code\n", 4, 2,   -10,-4,-8, 0)
	queue(init_ptextslot, 1, "blue\n", 4, 2,   -8,-1,-14, 0)
	queue(init_ptextslot, 2, "script\n", 6, 2, -10,3,-8, 0)
	queue(init_ptextslot, 3, "bifat\n", 5, 2,  0,-8,-14, 0)
	queue(init_ptextslot, 4, "music\n", 5, 2,  -10,6,-8, 0)
	return queue(init_ptextslot, 5, "banana\n", 6, 2, -8,2,-14, 0)
end

function init_clouds_part()
	queue(init_clouds)
	queue(init_ctext)
	return queue(init_ctextslot, 0, [[i have always been here
staring at the trees
now that you have found this place
you will still be me
]], 80, 4, 22,4,16, 0)
end

function init_end_part()
	queue(init_bubbles)
	queue(init_etext)
	return queue(init_etextslot, 0, [[
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
you've been watching

- innerloop -

released at
the ultimate meeting
2006 in karlsruhe



greetings...


oxyron
tek
rabenauge
rheingold
fan
drifters
smash designs
black maiden
farbrausch
digitale kultur e.v.





OMFG,
the playstation 2
is teh new amiga!!!11


- lots of memory
- ease of programming
- multimedia enabled
- dozens of coprocessors
- at least 123 subsets
of asm instructions







here's the credits
again:


blue - code
bifat - script
banana - music


visit our webpage:
www.neoscientists.org



you can also write to
blue, bifat and banana
at neoscientists.org,
respectively.



neoscientists is a
former division and
sideproject of the
electronic knights



the electronic knights
are also still active 
- watch out for their
latest releases on
the c16

















]], 230,10, -16,-11.6,0, 0.1)
end

-------------------------------------------------------------------------------
--	parts
-------------------------------------------------------------------------------

function part_helvete()
	
	runpart(2520, function()
	
		kill(5)
		local fr = 1
		local fg = 0.211765
		local fb = 0
		
		local ipf = interp_cos(15 * 50, 
			0.002, 0.002,	-- fog
			0, fr,			-- red
			0, fg,			-- green
			0, fb)			-- blue
		
		local ipl = interp_lin(25 * 50, 
			0, 0.414,		-- light
			0, 0.211)		-- ambient
		
		local ipf2 = interp_cos(10 * 50, 
			0.002, 0.000)	-- fog
		
		local ipf3 = interp_cos(5 * 50, 
			fr, 1,			-- red
			fg, 1,			-- green
			fb, 1)			-- blue
		
		local ips1 = interp_cos(20, 0.04, 0.01)
		local ips2 = interp_cos(50, 0.01, 0.04)
		
		local ipy1 = interp_cos(16, 
			0, 1,
			-5.42, -3.6,
			-1.888, -1.888)
		
		local ipy2 = interp_cos(70, 
			1, 0,
			-3.6, -5.42,
			-1.888, -1.888)
				
		local ipr1 = interp_cos(16, 
			-1.483088, -1.433088,
			0, 0.05789)
		local ipr2 = interp_cos(16, 
			-1.433088, -1.483088,
			0.05789, 0)
 		
 		call(0, do_helvete, -1)
		
		call(1, function(f)
				do_htexton(0, (f >= 420 and f < 1020))
				do_htexton(1, (f >= 900 and f < 1020))
				do_htexton(2, (f >= 1260 and f < 1500))
				do_htexton(3, (f >= 1680 and f < 2010))
				
				local c = getclap2()
				if f>=420 and f < 480 then do_htextefx(0, c*0.01 + 1) end
				if f>=1260 and f < 1320 then do_htextefx(2, c*0.01 + 1) end
				if f>=1680 and f < 1740 then do_htextefx(3, c*0.01 + 1) end
				
				if f>=1680-4 and f < 1700 then
					helvete_zoff(ips1())
					helvete_cam(ipy1())
					helvete_camrot(ipr1())
 				elseif f > 1850 and f < 1920 then
 					helvete_zoff(ips2())
					helvete_cam(ipy2())
					helvete_camrot(ipr2())
				end
				
				do_htext()
			end, -1)
		
		call(2, function(f)
				if f >= 0 and f < 15 * 50 then
					local f,r,g,b = ipf()
					helvete_fog(f)
					helvete_fogcol(r,g,b)
				end
 				if f >= 5 * 50 and f < 30 * 50 then 
 					helvete_light(ipl()) 
 				end 
 				if f >= 40 * 50 and f < 50 * 50 then
 					helvete_fog(ipf2())
 				end
 				if f >= 45 * 50 and f < 50 * 50 then
 					helvete_fogcol(ipf3())
 				end
			end, -1)
 			
	end)
	call(5, do_render, -1)
	exit_htext()
	exit_helvete()

end

--- --- - -  -   -

function part_particles()

	runpart(2185, function()
		
		local nums = 14 -- num sets
		
		local icol = interp_cos(85, 1, 0)
		
		do_setclearcolor(1,1,1,0.5)
		
		local sf = 0
		local nf = 0
		local np = 1
		local cf
		local s = 780
		
		local parts = {
   			{ 420, function(f) do_setclearcolor(1,1,1,0.5) set_particles(0) end },
   			{ 360, function(f) do_setclearcolor(1,1,1,0.5) set_particles(1) sf = f + 30 cf = function() do_party(getclap2() * -0.13) end end },
			{ 240, function(f) do_setclearcolor(1,1,1,0.5) set_particles(2) sf = f + 300 cf = function() do_party(getclap2() * -0.1) end end },
			{ 300, function(f) do_setclearcolor(1,1,1,0.5) set_particles(3) sf = f + 300 cf = function() do_partz(getclap2() * -0.56) end end },
			{ 300, function(f) do_setclearcolor(1,1,1,0.5) set_particles(4) sf = f + 300 cf = function() do_party(getclap2() * -0.4) end end },
 			{ 240, function(f) do_setclearcolor(0,0,0,0.5) set_particles(5) end },
			{ 120, function(f) do_setclearcolor(0,0,0,0.5) set_particles(6) end },
			{ 105, function(f) do_setclearcolor(0,0,0,0.5) set_particles(7) end },
 			{ 100, function(f) do_setclearcolor(1,1,1,0.5) set_particles(8) end },
			{ 10000, function(f) do_setclearcolor(1,1,1,0.5) set_particles(8) end },
		}
		
		rseed(125)
		
		call(1, function(f)
		
				do_ptexton(0, (f >= s+0 and f < s+60))
 				do_ptexton(1, (f >= s+120 and f < s+180))
 				do_ptexton(2, (f >= s+240 and f < s+300))
 				do_ptexton(3, (f >= s+360 and f < s+420))
 				do_ptexton(4, (f >= s+480 and f < s+540))
 				do_ptexton(5, (f >= s+540 and f < s+600))
				
 				local c = getclap2()*0.01 + 1
				if f>=s+0 and f < s+60 then do_ptextefx(0, c) end
				if f>=s+120 and f < s+180 then do_ptextefx(1, c) end
				if f>=s+240 and f < s+300 then do_ptextefx(2, c) end
				if f>=s+360 and f < s+420 then do_ptextefx(3, c) end
				if f>=s+480 and f < s+540 then do_ptextefx(4, c) end
				if f>=s+540 and f < s+600 then do_ptextefx(5, c) end
				
				do_ptext()
			end, 2000)
		
		wait(1)
		
		call(0, function(f)
		
				if f < 780 then
 					do_partaddrotz(0.00123)
 				end
				
				if f >= nf then
					nf = f + parts[np][1]
					parts[np][2](f)
					np = np + 1
				end
				
   				if f < sf then cf(f) end
				
				if f > 2100 then
					local c = icol()
					do_setclearcolor(c,c,c,0.5)
				end
				
				do_particles()
			
			end, -1)
	end)
	exit_ptext()
	exit_particles()
end

--- --- - -  -   -

function part_room()
	
	runpart(1380, function()
	
		local ip1 = interp_cos(3 * 50,
			0, 0.14, 
			0, 0.85, 
			0, 1.0)

		local ip2 = interp_cos(5 * 50,
			-4.765, -16)
			
		local ip3 = interp_cos(2 * 50,
			-16, -8.5)
	
		room_zcam(-4.765)
	
		do_setclearcolor(0, 0, 0, 0)
		wait(2)
 		room_glowbgcol(0.14, 0.85, 1.0)
		room_blurbgcol(0.0, 0.0, 0.0)
		room_bluron(true)
		
		local r,g,b,amb,c 
		
		call(0, function(f)
				if f < 150 then
					r,g,b = ip1()
			 		do_setclearcolor(r, g, b, 0)
			 	elseif f > 540 then
		 			c = f % 60
					if c < 30 then
						local c = 1 - ((rt.absframe - 20) % 20) / 20
						room_rot(c * c * c * 0.051)
					end
					if c >= 6 then
						room_bluron(true)
						do_setclearcolor(0.14, 0.85, 1.0, 0.0)		-- glow1
						room_blurbgcol(0.0, 0.0, 0.0)				-- bg
						room_light(0)
					else
						c = 1 - ((rt.absframe - 20) % 6) / 6
						room_bluron(false)
						do_setclearcolor(0, 0, 0, 0)
						room_light(c * c * 20)
					end
				elseif f >= 3 * 50 and f <= 8 * 50 then
			 		room_zcam(ip2())
			 	elseif f >= 8 * 50 and f <= 10 * 50 then
			 		room_zcam(ip3())
			 	end
			 	
			 	if f >= 260 and f < 420 then
			 		if f % 75 > 42 and f % 7 < 2 then
			 			room_lightcol(0.14, 0.85, 1.0)
				 		room_light(0.3)
				 	else
			 			room_lightcol(1, 0.3797, 0.1568)
				 		room_light(0)
				 	end
			 	end
		 		
				do_room(f)
			end, -1)
	end)
	exit_room()
end

--- --- - -  -   -

function part_land()
	
	runpart(2520, function()
		kill(5)
 		
 		set_land(0)
		
		local ipf1 = interp_lin(5 * 50, 
			0.000, 0.0007)
		
		local ipf2 = interp_cos(25 * 50, 
			0.0007, 0.005)
		
		local ipl1 = interp_cos(30 * 50, 
			-0.623599, 0.445546,
			0, -1.085009,
			0.567, 0.596932)
		
		local fr, fg, fb = 0.72, 0.75, 0.76
		
		local ipcol = interp_cos(40 * 50, 
			fr, 0.568628,
			fg, 0.721568,
			fb, 0.886274)
			
 		local ipland = interp_lin(10 * 50,
			1.57, 0.91,
			1.62, 0.94,
			1.66, 0.97,
			1.70, 1.00,
			1.74, 1.03,
			1.78, 1.08)
		
		local ipi = interp_cos(2 * 50,
			0, fr, 
			0, fg,
			0, fb)
		
		local ipf3 = interp_cos(200, 
			0.005, 0)
		local ipo = interp_cos(200,
			0.568628, 0.72,
			0.721568, 0.75,
			0.886274, 0.76)
		
		land_landcol(0.05, 0.09, 0.05)	-- fog of background plane
		land_fog(0)
		
		call(0, function(f)
		
				if f < 2 * 50 then
					local r,g,b = ipi()
					land_fogcol(r,g,b)
					do_setclearcolor(r,g,b,0.5)
				elseif f >= 2 * 50 and f < 7 * 50 then
  					land_abdeckplane(true)
					land_fog(ipf1())
				end
  				
				if f >= 15 * 50 and f < 45 * 50 then
					land_lightvec(ipl1())
				end
				
				if f >= 15 * 50 and f < 55 * 50 then
					local r,g,b = ipcol()
					land_fogcol(r,g,b)
 					do_setclearcolor(r, g, b)
				end
				
				if f >= 25 * 50 and f < 50 * 50 then
					land_fog(ipf2())
				end
				
 				if f >= 30 * 50 and f < 40 * 50 then
 					land_scale(ipland())
 				end
				
				if f > 2520-200 then
					local r,g,b = ipo()
					do_setclearcolor(r,g,b,0.5)
					land_fogcol(r,g,b)
					land_fog(ipf3())
				end
				
				do_newland(f, (f >= 100))
			end, -1)
			
	end)
 	do_setclearcolor(0.72,0.75,0.76,0.5)
	call(5, do_render, -1)
	exit_newland()
end

--- --- - -  -   -

function part_clouds()
	runpart(1380, function()
		
		local ipi = interp_cos(200, 0, 0.5)
		local ipo = interp_cos(350, 0.5, 0)
		
		local ipf = interp_lin(30 * 50,
			0.690196, 0.690196*0.87,
			0.686275, 0.626275*0.43,
			0.670588, 0.600588*0.43)
		
		local ip1 = interp_lin(30 * 50,
			60, 50,
			110, 115)
-- 			114.428139,)

		local abort
  		do_setclearcolor(0.72,0.75,0.76,0.5)
  		wait(2)
  		kill(-1)
		call(0, function(f)
				
				do_clouds(f)
				
				if f < 20 then
					clouds_clearscreen()
				end
				
				clouds_glow(ip1())
				clouds_fog(ipf())
				
				if f >= 500 then
					if f >= 500 and f < 700 then
						do_ctextefx(0,ipi())
					elseif f >= 950 then
						do_ctextefx(0,ipo())
					end
			
					do_ctexton(0, true)
					do_ctext()
				end
				
				if f == 1360 then
					abort = true
				end
				
			end, -1)
		while not abort do
			sync(queue(calc_clouds))
		end		
	end)
	do_setclearcolor(0,0,0,0.5)
 	call(-1, do_clearscreen, -1)
 	exit_ctext()
	exit_clouds()
end

--- --- - -  -   -

function part_bubbles()

	collectgarbage("stop")
	
	runpart(-1, function()
	
		local ipf = interp_cos(4500,
			126, 126/1.5,
			124, 124/1.6,
			120, 120/1.8,
			6, 3,
				135, 135/1.5,
				57, 57/1.6,
				12, 10/1.8,
				5, 3)
	
		do_setclearcolor(0,0,0,0.5)
 		wait(1)
 		call(0, function(f)
  				do_etexton(0, (f > 50))
  				do_etext()
  				if f < 4500 then
	 				bubble_col(ipf())
	 			end
	 			if f > 30 then
	 				do_bubbles(f)
	 			end
			end, -1)
		queue(fade_music)
	end)
 	exit_bubbles()
end

function showclaps()
	call(4, function(f)
		if f % 60 == 20 then
			do_setclearcolor(1,1,1,0)
		else
			do_setclearcolor(0,0,0,0)
		end
		end, -1)
end

-------------------------------------------------------------------------------
--	main
-------------------------------------------------------------------------------

-- 	avail("script entered")
	
	do_setclearcolor(0,0,0,0)
	startdmascreen()
	play_music(1)
   	wait(1)
  	resettime()
-- 	showclaps()
  	
--- --- - -  -   -
	
	if not ihelv then ihelv = init_helvete_part() end
	iparticles = init_particle_part()
waitabs(140)
	sync(ihelv)
	part_helvete()
 
--- --- - -  -   -
	
	if not iparticles then iparticles = init_particle_part() end
waitabs(2660)
	sync(iparticles)
	part_particles()

	collectgarbage("collect")
	collectgarbage("stop")
	
--- --- - -  -   -
	
	if not iroom then iroom = queue(init_room) end
	iland = queue(init_newland)
waitabs(5000-2)
	sync(iroom)
	part_room()

	collectgarbage("collect")
	collectgarbage("stop")

--- - -  -   -
	
	if not iland then iland = queue(init_newland) end
waitabs(6380)
	sync(iland)
	part_land()
	
--- --- - -  -   -
	
	if not iclouds then iclouds = init_clouds_part() end
waitabs(8900)
	sync(iclouds)
	part_clouds()
		
--- --- - -  -   -
  	
	if not ibubbles then ibubbles = init_end_part() end
waitabs(9980)
	sync(ibubbles)
	part_bubbles()

--- --- - -  -   -
	
	wait(-1)
