#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "sstring.h"

extern DWORD scr_cx_res;
extern DWORD scr_cy_res;
extern DWORD scr_bpp;
extern DWORD scr_freq;

extern float img_cx_scale;
extern float img_cy_scale;

void SeparatePath(char *full_name, SString &path, SString &file)
{
	path = "";
	file = "";

	int len = strlen(full_name);

	for (int i = len - 1; i >=0; i--)
	{
		if ((full_name[i] == '/') || (full_name[i] == '\\'))
			break;
	}

	if (i >= 0)
	{
		file = &full_name[i + 1];
		full_name[i + 1] = 0;
		path = full_name;
	}
	else
		file = full_name;
}

void ilReverseBitmap(BYTE *data, WORD cx, WORD cy)
{
	BYTE	*line = new BYTE[cx];

	for (WORD i = 0; i < (cy / 2); i++)
	{
		memcpy(line, (BYTE *)(data + cx * i), cx);
		memcpy((BYTE *)(data + cx * i), (BYTE *)(data + cx * (cy - i - 1)), cx);
		memcpy((BYTE *)(data + cx * (cy - i - 1)), line, cx);
	}

	delete [] line;
}

void ilReverseBitmapRGB(BYTE *data, DWORD c_pixels)
{
	BYTE	color;

	for (DWORD i = 0; i < c_pixels; i++)
	{
		color = data[i * 3];
		data[i * 3] = data[(i * 3) + 2];
		data[(i * 3) + 2] = color;
	}
}

void ScreenTo2D()
{
	glViewport(0, (int)(50.0f * img_cy_scale), scr_cx_res, (int)((768.0f-100.0f) * img_cy_scale));

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0, scr_cx_res, scr_cy_res, 0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glDisable(GL_DEPTH_TEST);
}

void ScreenTo3D()
{
	//glViewport(0, scr_cy_res/20, scr_cx_res, scr_cy_res - (scr_cy_res/20));
	glViewport(0, (int)(50.0f * img_cy_scale), scr_cx_res, (int)((768.0f-100.0f) * img_cy_scale));

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f, (float)scr_cx_res / (float)(scr_cy_res-(100.0f * img_cy_scale)), 0.01f, 100.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glEnable(GL_DEPTH_TEST);
}

void showFPS(float ms)
{
	static float fps_refresh;
	static char text_fps[10];

	fps_refresh += ms;
	if (fps_refresh > 1000.0f)
	{
		fps_refresh = 0;
		itoa((int)(1000.0f / ms), text_fps, 10);
	}

	ScreenTo2D();
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glRasterPos2d(0, 15);
	glColor3f(0.0f, 0.0f, 1.0f);
	glCallLists(strlen(text_fps), GL_UNSIGNED_BYTE, text_fps); 
	glEnable(GL_LIGHTING);
	glColor3f(1.0f, 1.0f, 1.0f);
}
